<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/datatables.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/prism.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/scrollbar.css')); ?>">
<?php $__env->stopSection(); ?>


<?php $__env->startSection('main_content'); ?>
    <div class="container-fluid">
        <div class="row page-title">
            <div class="col-sm-6">
                <h3>Administrar Usuarios</h3>
            </div>
            <div class="col-sm-6">
                <nav>
                    <ol class="breadcrumb justify-content-sm-end align-items-center">
                        <li class="breadcrumb-item"> <a href="<?php echo e(route('Main.Desktop')); ?>">
                                <svg class="svg-color">
                                    <use href="<?php echo e(asset('assets/svg/iconly-sprite.svg#Home')); ?>"></use>
                                </svg></a></li>
                        <li class="breadcrumb-item">Sistema</li>
                        <li class="breadcrumb-item active">Usuarios</li>
                    </ol>
                </nav>
            </div>
        </div>
    </div>

    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-header">
                        <div class="card-header-right">
                            <ul class="list-unstyled card-option f-16">
                                <li><i class="icon-more-alt"></i></li>
                                <!--<li><i class="view-html fa fa-code"></i></li>-->
                                <li><a href="<?php echo e(route('System.NewUser')); ?>" title="Nuevo"><i class="icofont icofont-plus-circle"></i></a></li>
                                <li><a href="<?php echo e(route('Extract.Users')); ?>" title="Exportar lista"><i class="icofont icofont-download-alt"></i></a></li>
                                <li><a href="#"><i class="icofont icofont-maximize full-card"></i></a></li>
                                <li><a href="#"><i class="icofont icofont-minus minimize-card"></i></a></li>
                                <!--<li><i class="icofont icofont-refresh reload-card"></i></li>
                                <li><i class="icofont icofont-error close-card"></i></li> -->
                            </ul>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="d-flex align-items-center gap-3 pills-blogger">
                            <div class="col-sm-12">
                                <form class="form theme-form raise-form">
                                            <div class="table-responsive">
                                                <table class="display" id="UserMaster" width="100%" >
                                                    <thead>
                                                        <tr>
                                                            <th >NOMBRE DE USUARIO</th>
                                                            <th >PROPIETARIO</th>
                                                            <th >ROL</th>
                                                            <th >ESTADO</th>
                                                            <th >ACTUALIZADO</th>
                                                            <th >...</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php $__currentLoopData = $Usuarios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $User): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <tr>
                                                                <td><?php echo e($User->cuenta); ?></td>
                                                                <td>
                                                                    <div class="d-flex align-items-center gap-2">
                                                                        <div class="flex-shrink-0"><img class="b-r-10" src="<?php echo e(($User->avatar) ? "storage/avatares/" . $User->avatar : 'storage/avatares/user.png'); ?>" alt="">
                                                                        </div>
                                                                        <div class="flex-grow-1">
                                                                            <a href="<?php echo e(route('System.EditUser', ['IdUser'=>$User->id_usuario])); ?>">
                                                                                <h6 class="f-w-500"><?php echo e($User->propietario); ?></h6>
                                                                            </a>
                                                                            <span class="font-light f-w-400 f-13"><?php echo e($User->correo_electronico); ?></span>
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <select name="sel_role" class="form-select sel-access-level" style="font-size: 10px;" onchange="SetRole('<?php echo e($User->id_usuario); ?>');">
                                                                        <option value = "<?php echo e($User->id_perfil); ?>" selected ><?php echo e($User->rol); ?></option>
                                                                        <?php $__currentLoopData = $Roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $Rol): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <?php if($User->id_perfil != $Rol->id_perfil): ?>
                                                                                <option value = "<?php echo e($Rol->id_perfil); ?>"  ><?php echo e($Rol->nombre); ?></option>
                                                                            <?php endif; ?>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                                    </select>
                                                                </td>
                                                                <td>
                                                                    <div class="form-check-size">
                                                                        <div class="form-check form-switch form-check-inline">
                                                                            <?php if($User->id_estado == 'CA'): ?>
                                                                                    <input class="form-check-input check-size" id="<?php echo e($User->id_usuario); ?>" type="checkbox" role="switch" checked="checked" title="Estado de la Cuenta" onchange="SetStatusUserTable('<?php echo e($User->id_usuario); ?>');">
                                                                            <?php else: ?>
                                                                                    <input class="form-check-input check-size" id="<?php echo e($User->id_usuario); ?>" type="checkbox" role="switch" title="Estado de la Cuenta" onchange="SetStatusUserTable('<?php echo e($User->id_usuario); ?>');">
                                                                            <?php endif; ?>
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                                <td><?php echo e($User->fuc); ?></td>
                                                                <td>
                                                                    <a href="<?php echo e(route('System.EditUser',['IdUser'=>$User->id_usuario])); ?>"
                                                                        class="m-0 btn-xs p-1 btn-outline-primary"
                                                                        type="button"
                                                                        title="Editar este registro"
                                                                        ><i class="icofont icon-pencil font-dark "></i>
                                                                    </a>
                                                                </td>
                                                            </tr>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Container-fluid ends-->
     <!--Alert Post AJAX-->
    <?php echo $__env->make('Alerts.AlertToast', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('assets/js/vendors/clipboard/dist/clipboard.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/clipboard/clipboard-script.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/prism/prism.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/custom-card/custom-card.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datatable/datatables/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datatable/datatables/datatables.gestor.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/height-equal.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/gestor.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master_main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Dev\Laravel12\Gestor\resources\views/Admin/Usuarios.blade.php ENDPATH**/ ?>