<!DOCTYPE html>
<html lang="en" <?php if(Route::currentRouteName()=='admin.rtl_layout'): ?> dir="rtl" <?php endif; ?>>

<head>

    <?php echo $__env->make('layouts.head', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <!-- Font awesome icon css -->
    <?php echo $__env->make('layouts.css', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</head>

<?php switch(Route::currentRouteName()):

    case ('admin.box_layout'): ?>
        <body class="box-layout">
        <?php break; ?>

    <?php case ('admin.rtl_layout'): ?>
        <body class="rtl">
        <?php break; ?>

    <?php case ('admin.dark_layout'): ?>
        <body>
        <?php break; ?>

    <?php default: ?>
        <body>
<?php endswitch; ?>

    <!-- tap to top starts-->
    <div class="tap-top">
        <svg class="feather">
            <use href="<?php echo e(asset('assets/svg/feather-icons/dist/feather-sprite.svg#arrow-up')); ?>"></use>
        </svg>
    </div>
    <!-- tap to tap ends-->

    <!-- loader starts-->
    <div class="loader-wrapper">
        <div class="loader"></div>
    </div>
    <!-- loader end-->

    <!-- page-wrapper Start-->
    <main class="page-wrapper compact-wrapper" id="pageWrapper">

        <!-- Page header start -->
        <?php echo $__env->make('layouts.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <!-- Page header end-->

        <!-- Page Body Start-->
        <div class="page-body-wrapper">

            <!-- Page sidebar start-->
            <div class="overlay"></div>
            <?php echo $__env->make('layouts.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <!-- Page sidebar end-->

            <div class="page-body">
                <?php echo $__env->yieldContent('main_content'); ?>
            </div>

            <!-- footer start-->
            <?php echo $__env->make('layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <!-- footer end-->

        </div>
    </main>

    
    <?php echo $__env->make('layouts.script', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php echo $__env->make('admin.inc.alerts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    

</body>
</html>
<?php /**PATH C:\Dev\Laravel12\Gestor\resources\views/layouts/master_main.blade.php ENDPATH**/ ?>