<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/datatables.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/scrollbar.css')); ?>">
<?php $__env->stopSection(); ?>


<?php $__env->startSection('main_content'); ?>
    <div class="container-fluid">
        <div class="row page-title">
            <div class="col-sm-6">
                <h3>Roles de Usuario</h3>
            </div>
            <div class="col-sm-6">
                <nav>
                    <ol class="breadcrumb justify-content-sm-end align-items-center">
                        <li class="breadcrumb-item"> <a href="<?php echo e(route('Main.Desktop')); ?>">
                                <svg class="svg-color">
                                    <use href="<?php echo e(asset('assets/svg/iconly-sprite.svg#Home')); ?>"></use>
                                </svg></a></li>
                        <li class="breadcrumb-item">Sistema</li>
                        <li class="breadcrumb-item"><a href="<?php echo e(route('System.Roles')); ?>">Roles de Usuario</a></li>
                        <li class="breadcrumb-item">Editar Roles</li>
                    </ol>
                </nav>
            </div>
        </div>
    </div>

    <!--Alert de Actualización -->
    <?php echo $__env->make('Alerts.AlertUpdate', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>


    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-body">
                        <div class="col-sm-12">
                                <form name="FrmRoles" class="theme-form row g-3" action="<?php echo e(route('System.UpdateRoles', ['IdRol'=>$Rol->id_perfil])); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <div class="col-sm-4 ">
                                                <label class="form-label">Nombre del Rol<span> *</span></label>
                                                <input class="form-control" type="text" name="nombre" id="nombre"
                                                        value="<?php echo e($Rol->nombre); ?>" placeholder="Nombre del Rol">
                                                    <?php $__errorArgs = ['nombre'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="text-danger">
                                                            <strong><?php echo e($message); ?></strong>
                                                        </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-sm-4">
                                                <label class="form-label">Proposito<span> *</span></label>
                                                <input class="form-control" type="text" name="proposito"
                                                        value="<?php echo e($Rol->proposito); ?>" placeholder="Proposito del rol">
                                                    <?php $__errorArgs = ['proposito'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="text-danger">
                                                            <strong><?php echo e($message); ?></strong>
                                                        </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-sm-4">
                                                <label class="form-label">Aplicación<span> *</span></label>
                                                <input class="form-control" type="text" name="aplicacion"
                                                        value="<?php echo e($Rol->aplicacion); ?>" placeholder="Aplicacion">
                                                    <?php $__errorArgs = ['aplicacion'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="text-danger">
                                                            <strong><?php echo e($message); ?></strong>
                                                        </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-sm-1">
                                        <button class="btn m-1 btn-outline-primary" type="submit"
                                                title="Guardar">Guardar</button>
                                    </div>
                                </form>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-12">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive theme-scrollbar">
                            <form class="form theme-form raise-form">
                                <table class="display" id="OpcionesList" class="basic_table" style="width:100%">
                                    <thead>
                                            <tr>
                                                <th width="50">ID</th>
                                                <th>NOMBRE</th>
                                                <th>PROPOSITO</th>
                                                <th>APLICACIÓN</th>
                                                <th>AUTORIZACIÓN</th>
                                            </tr>
                                    </thead>
                                    <tbody>
                                            <?php $__currentLoopData = $Opciones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $Op): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($Op->id_opcion); ?></td>
                                                    <td><?php echo e($Op->nombre); ?></td>
                                                    <td><?php echo e($Op->proposito); ?></td>
                                                    <td><?php echo e($Op->aplicacion); ?></td>
                                                    <td>
                                                        <select name="selec_opcion" class="form-select sel-access-level" onchange="SetLevel('<?php echo e($Op->id_opcion); ?>', '<?php echo e($Rol->id_perfil); ?>');">

                                                            <?php if($Op->nivel_acceso == 'R'): ?>
                                                                <option value = "R" selected >Solo Lectura</option>
                                                            <?php else: ?>
                                                                <option value = "R" >Solo Lectura</option>
                                                            <?php endif; ?>
                                                            <?php if($Op->nivel_acceso == 'W'): ?>
                                                                <option value = "W" selected >Acceso Total</option>
                                                            <?php else: ?>
                                                                <option value = "W">Acceso Total</option>
                                                            <?php endif; ?>
                                                            <?php if($Op->nivel_acceso == 'N'): ?>
                                                                <option value = "N" selected >Sin Acceso</option>
                                                            <?php else: ?>
                                                                <option value = "N" >Sin Acceso</option>
                                                            <?php endif; ?>
                                                        </select>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--Alert Post AJAX-->
        <?php echo $__env->make('Alerts.AlertToast', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    </div>
    <!-- Container-fluid ends-->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('assets/js/datatable/datatables/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datatable/datatables/datatables.gestor.js')); ?>"></script>
     <script src="<?php echo e(asset('assets/js/height-equal.js')); ?>"></script>
    <script>
        ///Esto es para los mensajitos!


     function SetLevel(IdOpcion, IdPerfil, e) {
            e = e || window.event;
            var select = e.target || e.srcElement;
            var NivelAcceso = select.options[select.selectedIndex].value;
            var NombreRol = $('#nombre').html();
            var IdOpcion = IdOpcion;
            var IdPerfil = IdPerfil;
            var ruta = "/Ajax/SetLevel";
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                type: "get",
                url: ruta,
                datatype: 'json',
                data: {NivelAcceso: NivelAcceso, IdOpcion: IdOpcion, IdPerfil: IdPerfil},

                success: function(R)
                {
                    const toast_alert = document.getElementById("alert_normal_saved");
                    const toast = new bootstrap.Toast(toast_alert);
                    toast.show();
                },
                error: function () {
                    toastr["warning"]("eRROR!");
                    //noty({text: 'Hubo un error al enviar los datos', layout: 'topRight', type: 'error'});
                    alert('Error');
                }

            });
        }
        </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master_main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Dev\Laravel12\Gestor\resources\views/Admin/EditRol.blade.php ENDPATH**/ ?>