<?php

use App\Http\Controllers\ExportAserprho;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\GestorAserprhoController;
use App\Http\Controllers\Parameters;
use App\Http\Controllers\AserprhoCartera;

//Starting...
Route::get('/', function () {
    return view('LogIn/LogIn', ['ErrorMsg'=>null]);
});
Route::get('/Desktop', [GestorAserprhoController::class,'Desktop'])->name('Main.Desktop');
//Basics
Route::post('/LogIn', [GestorAserprhoController::class,'LogIn'])->name('LogIn.Join');
Route::get('/LogOut', [GestorAserprhoController::class,'LogOut'])->name('Profile.LogOut');

//Profile
Route::get('/EditProfile', [GestorAserprhoController::class,'EditProfile'])->name('Profile.EditProfile');
Route::post('/UpdateProfile', [GestorAserprhoController::class,'UpdateProfile'])->name('Profile.UpdateProfile');
Route::post('/UpdateImageProfile', [GestorAserprhoController::class,'UpdateImageProfile'])->name('Profile.UpdateImageProfile');
Route::post('/UpdatePasswd', [GestorAserprhoController::class,'UpdatePasswd'])->name('Profile.UpdatePasswd');
//

//System
Route::get('/Roles', [GestorAserprhoController::class,'Roles'])->name('System.Roles');
Route::get('/EditRol/{IdRol}', [GestorAserprhoController::class,'EditRol'])->name('System.EditRol');
Route::post('/UpdateRoles', [GestorAserprhoController::class,'UpdateRoles'])->name('System.UpdateRoles');
Route::get('/NewRol', [GestorAserprhoController::class,'NewRol'])->name('System.NewRol');
Route::get('/Ajax/SetLevel', [GestorAserprhoController::class,'SetLevel']);
Route::get('/Usuarios', [GestorAserprhoController::class,'Usuarios'])->name('System.Users');
Route::get('/NewUser', [GestorAserprhoController::class,'NewUser'])->name('System.NewUser');
Route::get('/EditUser/{IdUser}', [GestorAserprhoController::class,'EditUser'])->name('System.EditUser');
Route::post('/UpdateUser', [GestorAserprhoController::class,'UpdateUser'])->name('System.UpdateUser');
Route::post('/GenPasswd', [GestorAserprhoController::class,'GenPasswd'])->name('System.GenPasswd');
Route::post('/Ajax/SetStatusUser', [GestorAserprhoController::class,'SetStatusUser']);
Route::post('/Ajax/SetRole', [GestorAserprhoController::class,'SetRole']);
Route::post('/Ajax/SetStatusRolTable', [GestorAserprhoController::class,'SetStatusRolTable']);

Route::get('/Parameters', [Parameters::class,'Parameters'])->name('System.Parameters');
Route::get('/Ajax/GetConcepto/{id_concepto}', [Parameters::class,'GetConcepto']);
Route::post('/SaveConceptos', [Parameters::class,'SaveConceptos'])->name('System.SaveConceptos');
Route::post('/Ajax/SetCobroHonorariosConcepto', [Parameters::class,'SetCobroHonorariosConcepto']);
Route::post('/Ajax/SetStatusConcepto', [Parameters::class,'SetStatusConcepto']);
Route::post('/SaveAcciones', [Parameters::class,'SaveAcciones'])->name('System.SaveAcciones');
Route::get('/Ajax/GetAccion/{id_accion}', [Parameters::class,'GetAccion']);
Route::post('/Ajax/SetStatusAcciones', [Parameters::class,'SetStatusAcciones']);
Route::post('/SaveResultados', [Parameters::class,'SaveResultados'])->name('System.SaveResultados');
Route::get('/Ajax/GetResultado/{id_resultado}', [Parameters::class,'GetResultado']);
Route::post('/Ajax/SetStatusResultado', [Parameters::class,'SetStatusResultado']);


//Clientes
Route::get('/Copropiedades', [AserprhoCartera::class,'Copropiedades'])->name('Customers.Master');
Route::get('/Ajax/ListarCopropiedades/{scope}', [AserprhoCartera::class,'ListarCopropiedades'])->name('Customers.ShowList');
Route::get('/EditCustomer/{IdCustomer}/{isUpdated}', [AserprhoCartera::class,'EditCustomer']);
Route::post('/UpdateCustomer', [AserprhoCartera::class,'UpdateAgrupacion'])->name('Customers.UpdateCustomer');
Route::get('/Ajax/ListarCartera/{id_agrupacion}', [AserprhoCartera::class,'ListarCartera1'])->name('Customers.ShowList2');
Route::post('/UpdateContact', [AserprhoCartera::class,'UpdateContact'])->name('Customers.UpdateContact');


//Export
Route::get('/ExportUsers', [ExportAserprho::class, 'ExportUsers'])->name('Extract.Users');
Route::get('/ExportConceptos', [ExportAserprho::class, 'ExportConceptos'])->name('Extract.Conceptos');
Route::get('/ExportResultados', [ExportAserprho::class, 'ExportResultados'])->name('Extract.Resultados');
Route::get('/ExportAcciones', [ExportAserprho::class, 'ExportAcciones'])->name('Extract.Acciones');
Route::get('/ExportResultados', [ExportAserprho::class, 'ExportResultados'])->name('Extract.Resultados');









