@extends('layouts.master_main')

@section('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/datatables.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/scrollbar.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/wowjs/css/libs/animate.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/select2/dist/css/select2.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/prism.css') }}">

@endsection

@section('main_content')
    <div class="container-fluid">
    <div class="row page-title">
        <div class="col-sm-6">
            <h3>Datos de la Copropiedad</h3>
        </div>
        <div class="col-sm-6">
            <nav>
                <ol class="breadcrumb justify-content-sm-end align-items-center">
                    <li class="breadcrumb-item"> <a href="{{route('Main.Desktop')}}">
                            <svg class="svg-color">
                                <use href="{{ asset('assets/svg/iconly-sprite.svg#Home') }}"></use>
                            </svg></a></li>
                    <li class="breadcrumb-item"><a href="{{route('Customers.Master')}}">Copropiedades</a></li>
                    <li class="breadcrumb-item">Datos de la Copropiedad</li>
                </ol>
            </nav>
        </div>
    </div>
    </div>
    <!--Alert de Actualización -->
    @include('Alerts.AlertUpdate')

    <!-- Container-fluid starts-->


        <div class="container-fluid">
            <div class="row">
                <div class="col-xl-6">
                    <form action="{{route('Customers.UpdateCustomer', ['IdAgrupacion'=>$Agrupacion->id_agrupacion])}}" method="post" novalidate class="theme-form row g-3">
                        @csrf
                        <div class="card b-w-3 b-t-warning">
                            <div class="card-header b-w-1 b-b-warning"><h4 class="card-title mb-0">Datos Generales</h4>
                                <div class="card-header-right">
                                    <ul class="list-unstyled card-option f-16">
                                        <li><i class="icon-more-alt"></i></li>
                                        <!--<li><i class="view-html fa fa-code"></i></li>-->
                                        <li><a href="{{route('System.NewUser')}}" data-bs-toggle="tooltip" data-bs-placement="bottom" title="" data-bs-original-title="Nueva Copropiedad"><i class="icofont icofont-plus-circle"></i></a></li>
                                        <li><a href="#"><i class="icofont icofont-maximize full-card"></i></a></li>
                                        <li><a href="#"><i class="icofont icofont-minus minimize-card"></i></a></li>
                                    </ul>
                                </div>
                            </div>
                            <!--Contenido del formulario-->
                            <div class="card-body">
                                    <div class="row">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="mb-3">
                                                    <label class="form-label">Nit</label>
                                                    <input class="form-control" placeholder="Nit" name="Nit" type="text"
                                                        value="{{$Agrupacion->nit}}">
                                                    @error('Nit')
                                                        <span class="text-danger">
                                                            <strong>{{ $message }}</strong>
                                                        </span>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6">
                                                <div class="mb-3">
                                                    <label class="form-label">Nombre<span> *</span></label>
                                                    <input class="form-control" type="text" placeholder="Nombre de la Copropiedad" name="Nombre"
                                                        value="{{ $Agrupacion->nombre }}">
                                                    @error('Nombre')
                                                        <span class="text-danger">
                                                            <strong>{{ $message }}</strong>
                                                        </span>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6">
                                                <div class="mb-3">
                                                    <label class="form-label">Nombre Comercial<span> *</span></label>
                                                    <input class="form-control" type="text" placeholder="Nombre comercial" name="NombreComercial"
                                                        value="{{ $Agrupacion->nombre_comercial }}">
                                                    @error('NombreComercial')
                                                        <span class="text-danger">
                                                            <strong>{{ $message }}</strong>
                                                        </span>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6">
                                                <div class="mb-3">
                                                    <label class="form-label">Domicilio</label>
                                                    <input class="form-control" type="text" placeholder="Carrera 4A #11-78" name="Domicilio"
                                                        value="{{ $Agrupacion->domicilio }}">
                                                    @error('Domicilio')
                                                        <span class="text-danger">
                                                            <strong>{{ $message }}</strong>
                                                        </span>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6">
                                                <div class="mb-3">
                                                    <label class="form-label">Teléfono</label>
                                                    <input class="form-control" type="text" name="Telefono"
                                                        value="{{$Agrupacion->telefono1}}">
                                                    @error('Telefono')
                                                        <span class="text-danger">
                                                            <strong>{{ $message }}</strong>
                                                        </span>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6">
                                                <div class="mb-3">
                                                    <label class="form-label">Teléfono Móvil:<span> *</span></label>
                                                    <input class="form-control" type="text" name="Celular"
                                                        value="{{ $Agrupacion->celular}}" placeholder="Ingresa el numero de móvil">
                                                    @error('Celular')
                                                        <span class="text-danger">
                                                            <strong>{{ $message }}</strong>
                                                        </span>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6">
                                                <div class="mb-3">
                                                    <label class="form-label">E-mail:</label>
                                                    <input class="form-control" type="email" placeholder="Ingresa un email" name="Email"
                                                        value="{{$Agrupacion->correo}}">
                                                    @error('Email')
                                                        <span class="text-danger">
                                                            <strong>{{ $message }}</strong>
                                                        </span>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6">
                                                <div class="mb-3">
                                                    <label class="form-label">Segmento</label>
                                                    <select class="form-select" id="id_segmento" name="id_segmento" >
                                                        @foreach ($Segmentos as $Segmento )
                                                            @if ($Segmento->id_segmento != $Agrupacion->id_segmento)
                                                                <option value = "{{$Segmento->id_segmento}}"  >{{$Segmento->nombre}}</option>
                                                            @else
                                                                <option value = "{{$Segmento->id_segmento}}" selected  >{{$Segmento->nombre}}</option>
                                                            @endif
                                                        @endforeach
                                                    </select>
                                                    @error('id_segmento')
                                                        <span class="text-danger">
                                                            <strong>{{ $message }}</strong>
                                                        </span>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-sm-3 col-md-3 b-l-warning b-w-2">
                                                    <div class="mb-3">
                                                        <label class="form-label-sm">% Hon. (Pre-Jurídico):</label>
                                                        <input class="form-control" type="number" placeholder="15.00" name="PercHonPre"
                                                            value="{{$Agrupacion->hon_juridico}}">
                                                        @error('PercHonPre')
                                                            <span class="text-danger">
                                                                <strong>{{ $message }}</strong>
                                                            </span>
                                                        @enderror
                                                    </div>
                                                </div>
                                                <div class="col-sm-3 col-md-3 b-l-danger b-w-2">
                                                    <div class="mb-3">
                                                        <label class="form-label-sm">% Hon. (Jurídico)</label>
                                                        <input class="form-control" type="number" placeholder="30.00" name="PercHonJuridico"
                                                            value="{{$Agrupacion->tasa_interes}}">
                                                        @error('PercHonJuridico')
                                                            <span class="text-danger">
                                                                <strong>{{ $message }}</strong>
                                                            </span>
                                                        @enderror
                                                    </div>
                                                </div>
                                                 <div class="col-sm-3 col-md-3 b-l-primary b-w-2">
                                                    <div class="mb-3">
                                                        <label class="form-label-sm">% Intereses</label>
                                                        <input class="form-control" type="number" name="PercInteres"
                                                            value="{{$Agrupacion->tasa_mora}}">
                                                        @error('PercInteres')
                                                            <span class="text-danger">
                                                                <strong>{{ $message }}</strong>
                                                            </span>
                                                        @enderror
                                                    </div>
                                                </div>
                                                <div class="col-sm-3 col-md-3 ">
                                                    <div class="mb-3">
                                                        <label class="form-label-sm">Cobro Iva</label>
                                                        <div class="form-check-size">
                                                            <div class="form-check form-switch form-check-inline">
                                                                @if($Agrupacion->cobrar_iva == '1')
                                                                        <input class="form-check-input check-size" id="cobrar_iva" name="cobrar_iva" type="checkbox" role="switch" checked="checked" title="Liquidar Iva" >
                                                                @else
                                                                        <input class="form-check-input check-size" id="cobrar_iva" name="cobrar_iva" type="checkbox" role="switch" title="Liquidar Iva" >
                                                                @endif
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-sm-4 col-md-4">
                                                    <div class="mb-3">
                                                        <label class="form-label-sm">No. Cuenta</label>
                                                        <input class="form-control" type="text" placeholder="040-000000" name="NumCuenta"
                                                            value="{{$Agrupacion->numero_cuenta}}">
                                                        @error('NumCuenta')
                                                            <span class="text-danger">
                                                                <strong>{{ $message }}</strong>
                                                            </span>
                                                        @enderror
                                                    </div>
                                                </div>
                                                <div class="col-sm-4 col-md-4">
                                                    <div class="mb-3">
                                                        <label class="form-label-sm">Banco</label>
                                                        <select class="form-select" id="id_banco" name="id_banco" >
                                                            @foreach ($Bancos as $Banco )
                                                                @if ($Banco->id_banco != $Agrupacion->id_banco)
                                                                    <option value = "{{$Banco->id_banco}}"  >{{$Banco->nombre}}</option>
                                                                @else
                                                                    <option value = "{{$Banco->id_banco}}" selected  >{{$Banco->nombre}}</option>
                                                                @endif
                                                            @endforeach
                                                        </select>
                                                        @error('id_banco')
                                                            <span class="text-danger">
                                                                <strong>{{ $message }}</strong>
                                                            </span>
                                                        @enderror
                                                    </div>
                                                </div>
                                                 <div class="col-sm-4 col-md-4">
                                                    <div class="mb-3">
                                                        <label class="form-label-sm">Tipo de cuenta</label>
                                                        <select name="TipoCuenta" id="TipoCuenta" class="form-select">
                                                            <option value="" >[Seleccionar]</option>
                                                            @if($Agrupacion->tipo_cuenta == 'AHORROS')
                                                                <option value="AHORROS" selected > AHORROS </option>
                                                            @else
                                                                <option value="AHORROS" > AHORROS </option>
                                                            @endif
                                                            @if($Agrupacion->tipo_cuenta == 'CORRIENTE')
                                                                <option value="CORRIENTE" selected > CORRIENTE </option>
                                                            @else
                                                                <option value="CORRIENTE" > CORRIENTE </option>
                                                            @endif
                                                            @if($Agrupacion->tipo_cuenta == 'REFERENCIA')
                                                                <option value="REFERENCIA" selected > REFERENCIA </option>
                                                            @else
                                                                <option value="REFERENCIA" > REFERENCIA </option>
                                                            @endif
                                                        </select>
                                                        @error('TipoCuenta')
                                                            <span class="text-danger">
                                                                <strong>{{ $message }}</strong>
                                                            </span>
                                                        @enderror
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-sm-4 col-md-4">
                                                    <div class="mb-3">
                                                        <label class="form-label-sm">Asesor</label>
                                                        <select class="form-select" id="id_owner" name="id_owner" >
                                                            @foreach ($Usuarios as $Usuario )
                                                                @if ($Usuario->id_usuario != $Agrupacion->id_owner)
                                                                    <option value = "{{$Usuario->id_usuario}}"  >{{$Usuario->propietario}}</option>
                                                                @else
                                                                    <option value = "{{$Usuario->id_usuario}}" selected >{{$Usuario->propietario}}</option>
                                                                @endif
                                                            @endforeach
                                                        </select>
                                                        @error('id_owner')
                                                            <span class="text-danger">
                                                                <strong>{{ $message }}</strong>
                                                            </span>
                                                        @enderror
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="mb-3">
                                                        <label class="form-label-sm">Administrador</label>
                                                        <input class="form-control" type="text" placeholder="Nombre del Administrador" name="NombreAdministrador"
                                                            value="{{$Agrupacion->administrador}}">
                                                        @error('NombreAdministrador')
                                                            <span class="text-danger">
                                                                <strong>{{ $message }}</strong>
                                                            </span>
                                                        @enderror
                                                    </div>
                                                </div>
                                                 <div class="col-sm-2 col-md-2">
                                                    <div class="mb-3">
                                                        <label class="form-label-sm">Estado</label>
                                                        <div class="form-check-size">
                                                            <div class="form-check form-switch form-check-inline">
                                                                @if($Agrupacion->id_estado == '1')
                                                                        <input class="form-check-input check-size" id="id_estado" name="id_estado" type="checkbox" role="switch" checked="checked" title="Estado de la Copropiedad" >
                                                                @else
                                                                        <input class="form-check-input check-size" id="id_estado" name="id_estado" type="checkbox" role="switch" title="Estado de la Copropiedad" >
                                                                @endif
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-sm-12 col-md-12 b-t-info b-w-1">
                                                    <div class="mb-3 mt-3">
                                                        <label class="form-label-sm">Observaciones</label>
                                                        <textarea name="Observaciones" id="Observaciones" class="form-control">{{$Agrupacion->observaciones}}</textarea>
                                                    </div>
                                                </div>
                                            </div>
                                    </div>
                            </div>
                            <div class="card-footer">
                                <div class="text-end">
                                    <button class="btn btn-outline-primary" type="submit">Actualizar</button>
                                </div>
                            </div>
                            <!--Aqui termina le Form datos de la Cuenta-->
                        </div>
                    </form>
                </div>

                <!--Seccion de la derecha-->
                <div class="col-xl-6">
                    <!--Tarjeta de Cartera-->

                    <div class="card b-w-3 b-t-info">
                        <div class="card-header b-w-1 b-b-info"><h4 class="card-title mb-0">Cartera</h4>
                                <div class="card-header-right">
                                    <ul class="list-unstyled card-option f-16">
                                        <li><i class="icon-more-alt"></i></li>
                                        <!--<li><i class="view-html fa fa-code"></i></li>-->
                                        <li><a href="{{route('System.NewUser')}}" data-bs-toggle="tooltip" data-bs-placement="bottom" title="" data-bs-original-title="Nueva Copropiedad"><i class="icofont icofont-plus-circle"></i></a></li>
                                        <li><a href="#" onclick="ListarCartera({{$Agrupacion->id_agrupacion}});" data-bs-toggle="tooltip" data-bs-placement="bottom" title="" data-bs-original-title="Actualizar"><i class="icofont icofont-refresh reload-card"></i></a></li>
                                        <li><a href="#"><i class="icofont icofont-maximize full-card"></i></a></li>
                                        <li><a href="#"><i class="icofont icofont-minus minimize-card"></i></a></li>
                                    </ul>
                                </div>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-sm-12 col-md-12">
                                    <div class="table-responsive">
                                        <small>
                                        <table class="display compact" id="TblCartera1" width="100%" >
                                            <thead>
                                                <tr>
                                                    <th >UNIDAD</th>
                                                    <th >TIPO</th>
                                                    <th ><div class="text-center">MESES</div></th>
                                                    <th ><div class="text-end">DEUDA</div></th>
                                                    <th width="30%">ESTADO</th>
                                                    <th >...</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                            <tfoot class="bg-light-info ">
                                                <th ><span class="badge badge-info f-12 "><i class="icofont icofont-home"></i> {{$TotalDeuda->cantidad}} Unidades.</span></th>
                                                <th colspan="2"><div class="f-w-600 text-end">TOTAL DEUDA</div></th>
                                                <th class="text-end f-w-600">${{number_format($TotalDeuda->total_deuda, 0)}}</th>
                                                <th colspan="2"></th>
                                            </tfoot>
                                        </table>
                                        </small>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div class="row">
                                <div class="col-xl-6 col-md-6 b-l-primary">
                                    <div class="d-flex gap-3">
                                        <div class="flex-shrink-0">
                                            <img class="img-40 b-r-15" src="{{ ($UsrCreador->avatar) ? "/storage/avatares/" . $UsrCreador->avatar : '/storage/avatares/user.png' }}">
                                        </div>
                                        <div class="flex-grow-1">
                                            <spam>
                                                <h6><small>Creado por </small><strong>{{ucwords(strtolower($UsrCreador->propietario))}}</strong></h6>
                                                <small>{{$Agrupacion->date_created}}</small>
                                            </spam>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-6 col-md-6 b-l-primary">
                                    <div class="d-flex gap-3 ">
                                        <div class="flex-shrink-0">
                                            <img class="img-40 b-r-15 " src="{{ ($UsrActualiza->avatar) ? "/storage/avatares/" . $UsrActualiza->avatar : '/storage/avatares/user.png' }}">
                                        </div>
                                        <div class="flex-grow-1">
                                            <spam>
                                                <h6><small>Actualizado por </small><strong>{{ucwords(strtolower($UsrActualiza->propietario))}}</strong></h6>
                                                <small>{{$Agrupacion->date_updated}}</small>
                                            </spam>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="card col-xl-7">
                                <div class="card-header b-b-success">
                                    <h5 class="card-title mb-0">Contactos</h5>
                                    <div class="card-header-right">
                                        <ul class="list-unstyled card-option f-16">
                                            <li><i class="icon-more-alt"></i></li>
                                            <li><a href="#" title="Nuevo Contacto" data-bs-toggle="modal" data-bs-target="#ModalEditContact"><i class="icofont icofont-plus-circle"></i></a></li>
                                            <li><a href="#"><i class="icofont icofont-maximize full-card"></i></a></li>
                                            <li><a href="#"><i class="icofont icofont-minus minimize-card"></i></a></li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <small>
                                        <table class="display table tbl_simple" id="TblContactos" width="100%" >
                                            <thead>
                                                <tr>
                                                    <th></th>
                                                    <th>NOMBRE</th>
                                                    <th>TELEFONO</th>
                                                    <th>EMAIL</th>
                                                    <th>POSICION</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                            @foreach ($Contactos as $Contacto )
                                                <tr>
                                                    <td></td>
                                                    <td><a href="#" class="f-w-300 f-11 btn btn-xs font-dark btn-light"
                                                            data-bs-toggle="modal"
                                                            data-bs-target="#ModalEditContact"
                                                            data-bs-nombrecontacto="{{$Contacto->nombre_contacto}}"
                                                            data-bs-telcontacto="{{$Contacto->telefono}}"
                                                            data-bs-emailcontacto="{{$Contacto->email}}"
                                                            data-bs-posicioncontacto="{{$Contacto->posicion}}"
                                                            data-bs-id="{{$Contacto->id}}"
                                                            >{{$Contacto->nombre_contacto}}</button>
                                                    </td>
                                                    <td>{{$Contacto->telefono}}</td>
                                                    <td>{{$Contacto->email}}</td>
                                                    <td>{{$Contacto->posicion}}</td>
                                                </tr>
                                            @endforeach
                                            </tbody>
                                        </table>
                                    </small>
                                </div>
                        </div>
                        <div class="card col-xl-5">
                                    <div class="card-header b-b-warning">
                                        <h5 class="card-title mb-0">Autorizaciones</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive f-12 "><small>
                                            <table class="display nowhrap table table-hoover tbl_simple" id="Tbl1"  width="100%" >
                                                <thead>
                                                    <tr>
                                                        <th>USUARIO AUTORIZADO</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach ($UsrAutorizados as $UsrAuth )
                                                    <tr><td>
                                                        <div class="flex-shrink-0">
                                                            <img class="img-30 b-r-15" src="{{ ($UsrAuth->avatar) ? "/storage/avatares/" . $UsrAuth->avatar : '/storage/avatares/user.png' }}">
                                                            <span>{{$UsrAuth->propietario}}</span>
                                                        </div>
                                                    </td></tr>
                                                    @endforeach
                                                </tbody>
                                            </table></small>
                                        </div>
                                    </div>
                        </div>
                    </div>

                </div>
                <!--Aqui termiala seccion de la derecha-->
            </div>
            <!--Aqui comienza la otra tarjeta de la izquierda..lista de copropiedades-->
            <div class="row">

            </div>
            <!--ModalEdicion de Contac tos-->
             @include('Modals.EditContact')
             <!--Alert Post AJAX-->
             @include('Alerts.AlertToast')
        </div>



@endsection
@section('scripts')
    <script src="{{ asset('assets/js/vendors/clipboard/dist/clipboard.min.js') }}"></script>
    <script src="{{ asset('assets/js/prism/prism.min.js') }}"></script>
    <script src="{{ asset('assets/js/custom-card/custom-card.js') }}"></script>

    <script src="{{ asset('assets/js/gestor.js') }}"></script>
    <script src="{{ asset('assets/js/tooltip-custom.js') }}"></script>
    <script src="{{ asset('assets/js/height-equal.js') }}"></script>
    <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/js/datatable/datatables/datatables.gestor.js') }}"></script>
    <script src="{{ asset('assets/js/datatable/datatable-extension/dataTables.responsive.min.js') }}"></script>


    <script>
        $(function() {
            ListarCartera({{$Agrupacion->id_agrupacion}});
        });

    </script>
@endsection
