@extends('layouts.master_main')
@section('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/datatables.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/prism.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/scrollbar.css') }}">
@endsection


@section('main_content')
    <div class="container-fluid">
        <div class="row page-title">
            <div class="col-sm-6">
                <h3>Maestro de Copropiedades</h3>
            </div>
            <div class="col-sm-6">
                <nav>
                    <ol class="breadcrumb justify-content-sm-end align-items-center">
                        <li class="breadcrumb-item"> <a href="{{route('Main.Desktop')}}">
                                <svg class="svg-color">
                                    <use href="{{ asset('assets/svg/iconly-sprite.svg#Home') }}"></use>
                                </svg></a></li>
                        <li class="breadcrumb-item">Clientes</li>

                    </ol>
                </nav>
            </div>
        </div>
    </div>

    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-header">
                        <div class="card-header-right">
                            <ul class="list-unstyled card-option f-16">
                                <li><i class="icon-more-alt"></i></li>
                                <!--<li><i class="view-html fa fa-code"></i></li>-->
                                <li><a href="{{route('System.NewUser')}}" data-bs-toggle="tooltip" data-bs-placement="bottom" title="" data-bs-original-title="Nueva Copropiedad"><i class="icofont icofont-plus-circle"></i></a></li>
                                <li><a href="{{route('Extract.Users')}}" data-bs-toggle="tooltip" data-bs-placement="bottom" title="" data-bs-original-title="Exportar"><i class="icofont icofont-download-alt"></i></a></li>
                                <li><a href="#" onclick="ListarCopropiedades(1);" data-bs-toggle="tooltip" data-bs-placement="bottom" title="" data-bs-original-title="Filtrar Activas"><i class="icofont icofont-filter"></i></a></li>
                                <li><a href="#" onclick="ListarCopropiedades(-1);" data-bs-toggle="tooltip" data-bs-placement="bottom" title="" data-bs-original-title="Mostrar Todo"><i class="icofont icofont-refresh reload-card"></i></a></li>
                                <li><a href="#"><i class="icofont icofont-maximize full-card"></i></a></li>
                                <li><a href="#"><i class="icofont icofont-minus minimize-card"></i></a></li>
                                <!--<li><i class="icofont icofont-refresh reload-card"></i></li>
                                <li><i class="icofont icofont-error close-card"></i></li> -->
                            </ul>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="d-flex align-items-center gap-3 pills-blogger">
                            <div class="col-sm-12">
                                <form class="form theme-form raise-form">
                                            <div class="table-responsive">
                                                <table class="display" id="TblCopropiedades" width="100%" >
                                                    <thead>
                                                        <tr>
                                                            <th >ID</th>
                                                            <th >NIT</th>
                                                            <th >NOMBRE</th>
                                                            <th >DOMICILIO</th>
                                                            <th >TELEFONO</th>
                                                            <th >CELULAR</th>
                                                            <th >E-MAIL</th>
                                                            <th class="text-end">ESTADO</th>
                                                            <th >...</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>

                                                    </tbody>
                                                </table>
                                            </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Container-fluid ends-->
     <!--Alert Post AJAX-->
    @include('Alerts.AlertToast')
@endsection

@section('scripts')
    <script src="{{ asset('assets/js/vendors/clipboard/dist/clipboard.min.js') }}"></script>
    <script src="{{ asset('assets/js/clipboard/clipboard-script.js') }}"></script>
    <script src="{{ asset('assets/js/prism/prism.min.js') }}"></script>
    <script src="{{ asset('assets/js/custom-card/custom-card.js') }}"></script>
    <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/js/datatable/datatables/datatables.gestor.js') }}"></script>
    <script src="{{ asset('assets/js/height-equal.js') }}"></script>
    <script src="{{ asset('assets/js/gestor.js') }}"></script>
    <script src="{{ asset('assets/js/tooltip-custom.js') }}"></script>

    <script>
        $(function() {
            ListarCopropiedades(-1);
        });
    </script>
@endsection
