        <div class="sm-12">
                <div class="collapse " id="FormEditConceptos" >
                    <form name="FrmConceptos" method = "post" action="{{route('System.SaveConceptos')}}" class="theme-form row" novalidate>
                        @csrf
                        <input type="hidden" name="IdConcepto" id="IdConcepto">
                        <div class="card-body default-border mb-3">
                            <div class="row">
                                <div class="col-sm-6 ">
                                    <label class="form-label">Nombre del concepto<span>*</span></label>
                                    <input class="form-control" type="text" name="NombreConcepto" id="NombreConcepto"
                                        value="" placeholder="Nombre del Concepto" >
                                    @error('NombreConcepto')
                                        <span class="text-danger">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="col-sm-3 ">
                                    <label class="form-label">Gen. Honorários</label>
                                    <div class="form-check-size">
                                        <div class="form-check form-switch form-check-inline">
                                            <input class="form-check-input check-size"
                                            id="cobro_honorarios"
                                            name="cobro_honorarios"
                                            type="checkbox"
                                            role="switch"
                                            title="Genera cobro de honorários"
                                            >
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-3 ">
                                    <label class="form-label">Estado</label>
                                    <div class="form-check-size">
                                        <div class="form-check form-switch form-check-inline">
                                            <input class="form-check-input check-size"
                                            id="id_estado_concepto"
                                            name="id_estado_concepto"
                                            type="checkbox" role="switch"
                                            title="Estado del Concepto" >
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div class="row">
                                <div class="text-end">
                                    <button class="btn btn-outline-primary" type="submit">Actualizar</button>
                                    <button class="btn font-dark btn-light btn-outline-light" type="button"
                                            data-bs-toggle="collapse"
                                            data-bs-target="#FormEditConceptos" aria-expanded="false"
                                            aria-controls="FormEditConceptos">Cerrar</button>
                                </div>
                            </div>
                        </div>
                        <hr>
                    </form>
                </div>
        </div>
        <div class="card p-2" >
            <div class="card-header-right">
                <button id="BtnNewConcepto"
                class="btn m-1 font-dark btn-light btn-outline-light"
                >Nuevo Concepto</button>
                <a href="{{route('Extract.Conceptos')}}" class="btn m-1 font-dark btn-light btn-outline-light">Exportar</a>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="display compact" id="TableConceptos" width="100%" >
                        <thead>
                            <tr>
                                <th >ID</th>
                                <th >NOMBRE</th>
                                <th >C.HONORARIOS</th>
                                <th >ESTADO</th>
                                <th >...</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($Conceptos as $Concepto )
                                <tr>
                                    <td>{{$Concepto->id_concepto}}</td>
                                    <td>{{$Concepto->nombre}}</td>
                                    <td>
                                        <div class="form-check-size">
                                            <div class="form-check form-switch form-check-inline">
                                                @if($Concepto->cobro_honorarios == 'SI')
                                                        <input class="form-check-input check-size" id="H{{$Concepto->id_concepto}}" type="checkbox" role="switch" checked="checked" title="Cobro de Honorarios" onchange="SetCobroHonorariosConcepto('{{$Concepto->id_concepto}}');">
                                                @else
                                                        <input class="form-check-input check-size" id="H{{$Concepto->id_concepto}}" type="checkbox" role="switch" title="Cobro de Honorarios" onchange="SetCobroHonorariosConcepto('{{$Concepto->id_concepto}}');">
                                                @endif
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="form-check-size">
                                            <div class="form-check form-switch form-check-inline switch-sm">
                                                @if($Concepto->control == 'S')
                                                        <input class="form-check-input check-size" id="E{{$Concepto->id_concepto}}" type="checkbox" role="switch" checked="checked" title="Concepto Activo" onchange="SetStatusConcepto('{{$Concepto->id_concepto}}');">
                                                @else
                                                        <input class="form-check-input check-size" id="E{{$Concepto->id_concepto}}" type="checkbox" role="switch" title="Concepto Inactivo" onchange="SetStatusConcepto('{{$Concepto->id_concepto}}');">
                                                @endif
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <button id="OpenClic" onclick="OpenFormEditConceptos({{$Concepto->id_concepto}});"
                                                    class="m-0 btn-xs p-1 btn-outline-primary"
                                                    type="button"
                                                    data-bs-toggle="collapse"
                                                    data-bs-target="#FormEditConceptos"
                                                    aria-expanded="false"
                                                    aria-controls="FormEditConceptos"
                                                    title="Editar este registro"
                                                    ><i class="icofont icon-pencil font-dark "></i>
                                        </button>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

