        <div class="sm-12">
                <div class="collapse " id="FormEditAcciones" >
                    <form name="FrmAcciones" method = "post" action="{{route('System.SaveAcciones')}}" class="theme-form row" novalidate>
                        @csrf
                        <input type="hidden" name="IdAccion" id="IdAccion">
                        <div class="card-body default-border mb-3">
                            <div class="row">
                                <div class="col-sm-6 ">
                                    <label class="form-label">Nombre de la acción<span>*</span></label>
                                    <input class="form-control" type="text" name="NombreAccion" id="NombreAccion"
                                        value="" placeholder="Nombre de la acción" >
                                    @error('NombreAccion')
                                        <span class="text-danger">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="col-sm-4 ">
                                    <label class="form-label">Estado final de la Cartera</label>
                                    <select class="form-select" id="IdEstadoFinal" name="IdEstadoFinal" >
                                                @foreach ($EstadosCartera as $EC )
                                                        <option value = "{{$EC->id_estado}}" >{{$EC->nombre}}</option>
                                                @endforeach
                                    </select>
                                </div>
                                <div class="col-sm-2 ">
                                    <label class="form-label">Estado</label>
                                    <div class="form-check-size">
                                        <div class="form-check form-switch form-check-inline">
                                            <input class="form-check-input check-size"
                                            id="id_estado_accion"
                                            name="id_estado_accion"
                                            type="checkbox" role="switch"
                                            title="Estado de la acción" >
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div class="row">
                                <div class="text-end">
                                    <button class="btn btn-primary" type="submit">Actualizar</button>
                                    <button class="btn btn-dark" id="BtnCloseAcciones" type="button"
                                    data-bs-toggle="collapse"
                                            data-bs-target="#FormEditAcciones" aria-expanded="false"
                                            aria-controls="FormEditAcciones" >Cerrar</button>
                                </div>
                            </div>
                        </div>
                        <hr>
                    </form>
                </div>
        </div>
        <div class="card p-2" >
            <div class="card-header-right">
                <button id="BtnNewAccion"
                class="btn m-1 font-dark btn-light btn-outline-light"
                >Nueva Acción</button>
                <a href="{{route('Extract.Acciones')}}" class="btn m-1 font-dark btn-light btn-outline-light">Exportar</a>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="display compact" id="TableAcciones" width="100%" >
                        <thead>
                            <tr>
                                <th >ID</th>
                                <th >NOMBRE</th>
                                <th >E.CARTERA</th>
                                <th >ESTADO</th>
                                <th >...</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($Acciones as $Accion )
                                <tr>
                                    <td>{{$Accion->id_accion}}</td>
                                    <td>{{$Accion->nombre}}</td>
                                    <td>{{$Accion->estado_final}}</td>
                                    <td>
                                        <div class="form-check-size">
                                            <div class="form-check form-switch form-check-inline">
                                                @if($Accion->control == 'A')
                                                        <input class="form-check-input check-size" id="{{$Accion->id_accion}}" type="checkbox" role="switch" checked="checked" title="Registro Activo" onchange="SetStatusAcciones('{{$Accion->id_accion}}');">
                                                @else
                                                        <input class="form-check-input check-size" id="{{$Accion->id_accion}}" type="checkbox" role="switch" title="Registro Inactivo" onchange="SetStatusAcciones('{{$Accion->id_accion}}');">
                                                @endif
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                            <button id="OpenClic" onclick="OpenFormEditAccion({{$Accion->id_accion}});"
                                                        class="m-0 btn-xs p-1 btn-outline-primary"
                                                        type="button"
                                                        data-bs-toggle="collapse"
                                                        data-bs-target="#FormEditAcciones"
                                                        aria-expanded="false"
                                                        aria-controls="FormEditAcciones"
                                                        title="Editar este registro"
                                                        ><i class="icofont icon-pencil font-dark "></i>
                                            </button>
                                        </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

