@extends('layouts.master_main')

@section('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/datatables.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/scrollbar.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/select2/dist/css/select2.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/prism.css') }}">

@endsection

@section('main_content')
<div class="container-fluid">
  <div class="row page-title">
      <div class="col-sm-6">
          <h3>Datos de Usuario</h3>
      </div>
      <div class="col-sm-6">
          <nav>
              <ol class="breadcrumb justify-content-sm-end align-items-center">
                  <li class="breadcrumb-item"> <a href="{{route('Main.Desktop')}}">
                          <svg class="svg-color">
                              <use href="{{ asset('assets/svg/iconly-sprite.svg#Home') }}"></use>
                          </svg></a></li>
                  <li class="breadcrumb-item"><a href="{{route('System.Users')}}">Usuarios</a></li>
                  <li class="breadcrumb-item">Registro de Usuarios</li>
              </ol>
          </nav>
      </div>
  </div>
</div>
<!--Alert de Actualización -->
    @include('Alerts.AlertUpdate')
<!-- Container-fluid starts-->

        <div class="container-fluid edit-profile">
            <div class="row">
                <div class="card col-xl-8">
                    <div class="card-header">
                        <div class="card-header-right">
                            <ul class="list-unstyled card-option f-16">
                                <li><i class="icon-more-alt"></i></li>
                                <!--<li><i class="view-html fa fa-code"></i></li>-->
                                <li><a href="{{route('System.NewUser')}}" title="Nuevo"><i class="icofont icofont-plus-circle"></i></a></li>
                                <li><a href="{{route('System.GenPasswd')}}" title="Generar Contraseña y enviar por correo"><i class="icofont icofont-lock"></i></a></li>
                                <li><a href="#"><i class="icofont icofont-maximize full-card"></i></a></li>
                                <li><a href="#"><i class="icofont icofont-minus minimize-card"></i></a></li>
                            </ul>
                        </div>
                    </div>
                    <!--Contenido del formulario datos de la cuenta-->
                    <div class="card-body">
                         <form action="{{route('System.UpdateUser', ['id_usuario'=>$CurrentUser->id_usuario])}}" method="post" novalidate>
                            @csrf
                            <div class="row">
                                    <div class="col-sm-6 col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label">Cuenta:</label>
                                            <input class="form-control" placeholder="email@domain.com" name="email"
                                                value="{{$CurrentUser->cuenta}}">
                                            @error('email')
                                                <span class="text-danger">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-sm-6 col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label">E-mail alternativo:<span> *</span></label>
                                            <input class="form-control" type="email" placeholder="Email" name="email2"
                                                value="{{ $CurrentUser->correo_electronico }}">
                                            @error('email2')
                                                <span class="text-danger">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-sm-6 col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label">Nombre completo:<span> *</span></label>
                                            <input class="form-control" type="text" placeholder="Nombre completo" name="fullname"
                                                value="{{ $CurrentUser->propietario }}">
                                            @error('fullname')
                                                <span class="text-danger">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-sm-6 col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label">Teléfono fijo:</label>
                                            <input class="form-control" type="number" placeholder="Telefono" name="telfijo"
                                                value="{{ $CurrentUser->telefono }}">
                                            @error('telfijo')
                                                <span class="text-danger">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-sm-6 col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label">Domicilio:</label>
                                            <input class="form-control" type="text" placeholder="Direccion" name="domicilio"
                                                value="{{$CurrentUser->domicilio}}">
                                            @error('domicilio')
                                                <span class="text-danger">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-sm-6 col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label">Teléfono Móvil:<span> *</span></label>
                                            <input class="form-control" type="number" name="celular"
                                                value="{{ $CurrentUser->celular}}" placeholder="Número de Móvil">
                                            @error('celular')
                                                <span class="text-danger">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-sm-6 col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label">Ciudad:</label>
                                            <input class="form-control" type="text" placeholder="Ciudad" name="ciudad"
                                                value="{{$CurrentUser->ciudad}}">
                                            @error('ciudad')
                                                <span class="text-danger">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-sm-6 col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label" for="select">Rol de usuario:</label>
                                            <select class="form-select" id="id_perfil" name="id_perfil" >
                                                @foreach ($Roles as $Rol )
                                                    @if ($CurrentUser->id_perfil != $Rol->id_perfil)
                                                        <option value = "{{$Rol->id_perfil}}"  >{{$Rol->nombre}}</option>
                                                    @else
                                                        <option value = "{{$Rol->id_perfil}}"  selected >{{$Rol->nombre}}</option>
                                                    @endif
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-4 col-md-3">
                                        <div class="mb-3">
                                            <label class="form-label">Fecha de creación:</label>
                                            <input class="form-control" type="text" placeholder="Ciudad" name="date1" disabled
                                                value="{{$CurrentUser->fecha_creacion}}">
                                        </div>
                                    </div>
                                    <div class="col-sm-4 col-md-3">
                                        <div class="mb-3">
                                            <label class="form-label">Última actualización:</label>
                                            <input class="form-control" type="text" name="date2" disabled
                                                value="{{$CurrentUser->fecha_ultimo_cambio}}">
                                        </div>
                                    </div>
                                    <div class="col-sm-4 col-md-3">
                                        <div class="mb-3">
                                            <label class="form-label">Estado de la Cuenta:</label>
                                            <div class="form-check-size">
                                                <div class="form-check form-switch form-check-inline">
                                                    @if($CurrentUser->id_estado == 'CA')
                                                            <input class="form-check-input check-size" id="id_estado" name="id_estado" type="checkbox" role="switch" checked="checked" value="CA" title="Estado de la Cuenta" onchange="SetStatusUser('{{$CurrentUser->id_usuario}}', 'CA');">
                                                    @else
                                                            <input class="form-check-input check-size" id="id_estado" name="id_estado" type="checkbox" role="switch" title="Estado de la Cuenta" value="CI" onchange="SetStatusUser('{{$CurrentUser->id_usuario}}', 'CI');">
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="text-end">
                                    <button class="btn btn-primary" type="submit">Actualizar</button>
                                </div>
                            </div>
                         </form>
                    </div>
                    <!--Aqui termina le Form datos de la Cuenta-->
                </div>
                <!--Seccion de la derecha-->
                <div class="col-xl-4">
                    <div class="card">
                        <div class="card-body">
                            <div class="row mb-2">
                                <div class="profile-title">
                                    <div class="d-flex">
                                        @php
                                            //*$image = auth()->user()->getFirstMedia('image');
                                            $image = ($CurrentUser->avatar) ? "/storage/avatares/" . $CurrentUser->avatar : '/storage/avatares/user.png';
                                        @endphp

                                        @isset($image)
                                            <img src="{{ $image}}" alt="Image" class="img-70 rounded-circle">
                                        @endisset
                                        <div class="flex-grow-1">
                                            <h5 class="mb-1">
                                                {{ $CurrentUser->propietario }}
                                            </h5>
                                            <p>{{ session('rol') }}</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <hr>
                        </div>
                    </div>
                </div>
                <!--Aqui termiala seccion de la derecha-->
            </div>
            <!--Aqui comienza la otra tarjeta de la izquierda..lista de copropiedades-->
            <div class="row">
                <div class="card col-xl-8">
                    <div class="card-header">
                        <h4 class="card-title mb-0">Autorizaciones</h4>
                        <div class="card-header-right">
                            <ul class="list-unstyled card-option f-16">
                                <li><i class="icon-more-alt"></i></li>
                                <li><a href="#"><i class="icofont icofont-maximize full-card"></i></a></li>
                                <li><a href="#"><i class="icofont icofont-minus minimize-card"></i></a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="card-body"></div>
                        <div class="row mb-2">
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <table class="display dataTable" style="font-size: 11px;" id="ListCoop" width="100%" >
                                        <thead>
                                            <tr>
                                                <th >...</th>
                                                <th >CLIENTE</th>
                                                <th >UNIDADES</th>
                                                <th >AUTORIZACIÓN</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($MasterCustomer as $Mc )
                                                <tr>
                                                    <td>{{$loop->iteration}}</td>
                                                    <td>{{$Mc->nombre}}</td>
                                                    <td>{{$Mc->unidades}}</td>
                                                    <td>
                                                        <div class="form-check-size">
                                                            <div class="form-check form-switch form-check-inline">
                                                                @if($Mc->Permitido == 'SI')
                                                                        <input class="form-check-input check-size" id="{{$Mc->id_agrupacion}}" type="checkbox" role="switch" checked="checked" title="Acceso permitido" onchange="SetAccesToCustomer('{{$Mc->id_agrupacion}}');">
                                                                @else
                                                                        <input class="form-check-input check-size" id="{{$Mc->id_agrupacion}}" type="checkbox" role="switch" title="Acceso Denegado" onchange="SetAccesToCustomer('{{$Mc->id_agrupacion}}');">
                                                                @endif
                                                            </div>
                                                        </div>
                                                    </td>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
             <!--Alert Post AJAX-->
             @include('Alerts.AlertToast')
        </div>



@endsection
@section('scripts')
    <script src="{{ asset('assets/js/vendors/clipboard/dist/clipboard.min.js') }}"></script>
    <script src="{{ asset('assets/js/prism/prism.min.js') }}"></script>
    <script src="{{ asset('assets/js/custom-card/custom-card.js') }}"></script>
    <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/js/datatable/datatables/datatables.gestor.js') }}"></script>
    <script src="{{ asset('assets/js/gestor.js') }}"></script>
@endsection
