@extends('layouts.master_main')
@section('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/datatables.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/scrollbar.css') }}">
@endsection


@section('main_content')
    <div class="container-fluid">
        <div class="row page-title">
            <div class="col-sm-6">
                <h3>Roles de Usuario</h3>
            </div>
            <div class="col-sm-6">
                <nav>
                    <ol class="breadcrumb justify-content-sm-end align-items-center">
                        <li class="breadcrumb-item"> <a href="{{route('Main.Desktop')}}">
                                <svg class="svg-color">
                                    <use href="{{ asset('assets/svg/iconly-sprite.svg#Home') }}"></use>
                                </svg></a></li>
                        <li class="breadcrumb-item">Sistema</li>
                        <li class="breadcrumb-item"><a href="{{route('System.Roles')}}">Roles de Usuario</a></li>
                        <li class="breadcrumb-item">Editar Roles</li>
                    </ol>
                </nav>
            </div>
        </div>
    </div>

    <!--Alert de Actualización -->
    @include('Alerts.AlertUpdate')


    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-body">
                        <div class="col-sm-12">
                                <form name="FrmRoles" class="theme-form row g-3" action="{{route('System.UpdateRoles', ['IdRol'=>$Rol->id_perfil])}}" method="POST">
                                    @csrf
                                    <div class="col-sm-4 ">
                                                <label class="form-label">Nombre del Rol<span> *</span></label>
                                                <input class="form-control" type="text" name="nombre" id="nombre"
                                                        value="{{ $Rol->nombre}}" placeholder="Nombre del Rol">
                                                    @error('nombre')
                                                        <span class="text-danger">
                                                            <strong>{{ $message }}</strong>
                                                        </span>
                                                    @enderror
                                    </div>
                                    <div class="col-sm-4">
                                                <label class="form-label">Proposito<span> *</span></label>
                                                <input class="form-control" type="text" name="proposito"
                                                        value="{{ $Rol->proposito}}" placeholder="Proposito del rol">
                                                    @error('proposito')
                                                        <span class="text-danger">
                                                            <strong>{{ $message }}</strong>
                                                        </span>
                                                    @enderror
                                    </div>
                                    <div class="col-sm-4">
                                                <label class="form-label">Aplicación<span> *</span></label>
                                                <input class="form-control" type="text" name="aplicacion"
                                                        value="{{ $Rol->aplicacion}}" placeholder="Aplicacion">
                                                    @error('aplicacion')
                                                        <span class="text-danger">
                                                            <strong>{{ $message }}</strong>
                                                        </span>
                                                    @enderror
                                    </div>
                                    <div class="col-sm-1">
                                        <button class="btn m-1 btn-outline-primary" type="submit"
                                                title="Guardar">Guardar</button>
                                    </div>
                                </form>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-12">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive theme-scrollbar">
                            <form class="form theme-form raise-form">
                                <table class="display" id="OpcionesList" class="basic_table" style="width:100%">
                                    <thead>
                                            <tr>
                                                <th width="50">ID</th>
                                                <th>NOMBRE</th>
                                                <th>PROPOSITO</th>
                                                <th>APLICACIÓN</th>
                                                <th>AUTORIZACIÓN</th>
                                            </tr>
                                    </thead>
                                    <tbody>
                                            @foreach ($Opciones as $Op )
                                                <tr>
                                                    <td>{{$Op->id_opcion}}</td>
                                                    <td>{{$Op->nombre}}</td>
                                                    <td>{{$Op->proposito}}</td>
                                                    <td>{{$Op->aplicacion}}</td>
                                                    <td>
                                                        <select name="selec_opcion" class="form-select sel-access-level" onchange="SetLevel('{{$Op->id_opcion}}', '{{$Rol->id_perfil}}');">

                                                            @if ($Op->nivel_acceso == 'R')
                                                                <option value = "R" selected >Solo Lectura</option>
                                                            @else
                                                                <option value = "R" >Solo Lectura</option>
                                                            @endif
                                                            @if ($Op->nivel_acceso == 'W')
                                                                <option value = "W" selected >Acceso Total</option>
                                                            @else
                                                                <option value = "W">Acceso Total</option>
                                                            @endif
                                                            @if ($Op->nivel_acceso == 'N')
                                                                <option value = "N" selected >Sin Acceso</option>
                                                            @else
                                                                <option value = "N" >Sin Acceso</option>
                                                            @endif
                                                        </select>
                                                    </td>
                                                </tr>
                                            @endforeach
                                    </tbody>
                                </table>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--Alert Post AJAX-->
        @include('Alerts.AlertToast')

    </div>
    <!-- Container-fluid ends-->
@endsection

@section('scripts')
    <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/js/datatable/datatables/datatables.gestor.js') }}"></script>
     <script src="{{ asset('assets/js/height-equal.js') }}"></script>
    <script>
        ///Esto es para los mensajitos!


     function SetLevel(IdOpcion, IdPerfil, e) {
            e = e || window.event;
            var select = e.target || e.srcElement;
            var NivelAcceso = select.options[select.selectedIndex].value;
            var NombreRol = $('#nombre').html();
            var IdOpcion = IdOpcion;
            var IdPerfil = IdPerfil;
            var ruta = "/Ajax/SetLevel";
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                type: "get",
                url: ruta,
                datatype: 'json',
                data: {NivelAcceso: NivelAcceso, IdOpcion: IdOpcion, IdPerfil: IdPerfil},

                success: function(R)
                {
                    const toast_alert = document.getElementById("alert_normal_saved");
                    const toast = new bootstrap.Toast(toast_alert);
                    toast.show();
                },
                error: function () {
                    toastr["warning"]("eRROR!");
                    //noty({text: 'Hubo un error al enviar los datos', layout: 'topRight', type: 'error'});
                    alert('Error');
                }

            });
        }
        </script>

@endsection
