<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateProfileRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'email'=> 'required|email|max:60',
            'email2'=> 'required|email|max:60',
            'fullname'=> 'required|max:60',
            'telfijo'=> 'max_digits:20|integer',
            'domicilio'=> 'required|max:80',
            'celular'=> 'required|max_digits:20|integer',
            'ciudad'=> 'required|max:45',
        ];
    }
}
