<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Http\Requests\UpdateConceptoRequest;
use App\Http\Requests\UpdateAccionesRequest;
use App\Http\Requests\UpdateResultadosRequest;
use Illuminate\Support\Facades\DB;
//Modelos
use App\Models\ConceptosCartera;
use App\Models\Acciones;
use App\Models\EstadoCartera;
use App\Models\Resultados;

//Extensiones
use PhpOffice\PhpSpreadsheet\Writer\Xlsx\Rels;

class Parameters extends Controller
{
     function Parameters(){
         if (session()->has('id_usuario')) {
            $Conceptos = ConceptosCartera::orderBy('nombre')->get();
            $Acciones = DB::table('tbl_acciones')
                        ->join('tbl_estados', 'tbl_estados.id_estado', '=', 'tbl_acciones.id_estado_final')
                        ->select('tbl_acciones.id_accion', 'tbl_acciones.nombre', 'tbl_acciones.control', 'tbl_acciones.id_estado_final', 'tbl_estados.nombre as estado_final')->orderBy('tbl_acciones.nombre')->get();

            $Resultados = DB::table('tbl_resultados')
                        ->join('tbl_estados', 'tbl_estados.id_estado', '=', 'tbl_resultados.id_estado')
                        ->select('tbl_resultados.id_resultado', 'tbl_resultados.nombre', 'tbl_resultados.control', 'tbl_resultados.id_estado', 'tbl_estados.nombre as estado_final')->orderBy('tbl_resultados.nombre')->get();

            Acciones::orderBy('nombre')->get();
            $EstadosCartera = EstadoCartera::orderBy('nombre')->get();
            return view('Admin.Parameters',
                ['Conceptos'=>$Conceptos,
                 'Acciones'=>$Acciones,
                 'EstadosCartera'=>$EstadosCartera,
                 'Resultados'=>$Resultados,
                'isUpdated'=>false ]);}
        else {
            return view('LogIn/LogIn', ['ErrorMsg'=>null]);
        }
    }

    function GetConcepto($id_concepto){
         if (session()->has('id_usuario')) {
            $CurrentConcepto = ConceptosCartera::find($id_concepto);
            return $CurrentConcepto;}
        else {
            return view('LogIn/LogIn', ['ErrorMsg'=>null]);
        }
    }

    function SaveConceptos(UpdateConceptoRequest $request) {
        if (session()->has('id_usuario')) {
            if ($request->IdConcepto){
                $Conceptos = ConceptosCartera::find($request->IdConcepto);
            } else {
                $Conceptos = new ConceptosCartera();
            }
            $Conceptos->nombre = strtoupper($request->NombreConcepto);
            $Conceptos->control = ($request->id_estado_concepto) ? 'S' : 'N';
            $Conceptos->cobro_honorarios = ($request->cobro_honorarios) ? 'SI' : 'NO';
            $Conceptos->save();
            $Conceptos = ConceptosCartera::orderBy('nombre')->get();
            $Acciones = DB::table('tbl_acciones')
                        ->join('tbl_estados', 'tbl_estados.id_estado', '=', 'tbl_acciones.id_estado_final')
                        ->select('tbl_acciones.id_accion', 'tbl_acciones.nombre', 'tbl_acciones.control', 'tbl_acciones.id_estado_final', 'tbl_estados.nombre as estado_final')->orderBy('tbl_acciones.nombre')->get();
            $Resultados = DB::table('tbl_resultados')
                        ->join('tbl_estados', 'tbl_estados.id_estado', '=', 'tbl_resultados.id_estado')
                        ->select('tbl_resultados.id_resultado', 'tbl_resultados.nombre', 'tbl_resultados.control', 'tbl_resultados.id_estado', 'tbl_estados.nombre as estado_final')->orderBy('tbl_resultados.nombre')->get();

            Acciones::orderBy('nombre')->get();
            $EstadosCartera = EstadoCartera::orderBy('nombre')->get();
            return view('Admin.Parameters',
                ['Conceptos'=>$Conceptos,
                 'Acciones'=>$Acciones,
                 'EstadosCartera'=>$EstadosCartera,
                 'Resultados'=>$Resultados,
                'isUpdated'=>true ]);
        } else {
            return view('LogIn/LogIn', ['ErrorMsg'=>null]);
        }
    }

    function SetCobroHonorariosConcepto(Request $request){
        //Mafrcar el registro para cobro de honorarios
        $Ahora = now();
        $Hoy = $Ahora->format('Y-m-d');
        $IdConcepto = $request->IdConcepto;
        $CobroHonorarios = $request->CobroHonorarios;

        $CorrentConcepto = ConceptosCartera::find($IdConcepto);
        $CorrentConcepto->cobro_honorarios = $CobroHonorarios;
        $Resp = $CorrentConcepto->save();
       return $Resp;
    }

    function SetStatusConcepto(Request $request){
        //Cambiar el estado al Registro
        $Ahora = now();
        $Hoy = $Ahora->format('Y-m-d');
        $IdConcepto = $request->IdConcepto;
        $IdEstado = $request->IdEstado;

        $CorrentConcepto = ConceptosCartera::find($IdConcepto);
        $CorrentConcepto->control = $IdEstado;
        $Resp = $CorrentConcepto->save();
       return $Resp;
    }

    function SaveAcciones(UpdateAccionesRequest $request) {
        if (session()->has('id_usuario')) {
            if ($request->IdAccion){
                $Acciones = Acciones::find($request->IdAccion);
            } else {
                $Acciones = new Acciones();
            }
            $Acciones->nombre = strtoupper($request->NombreAccion);
            $Acciones->control = ($request->id_estado_accion) ? 'A' : 'N';
            $Acciones->id_estado_final = $request->IdEstadoFinal;
            $Acciones->save();
            $Acciones = ConceptosCartera::orderBy('nombre')->get();
            $Conceptos = ConceptosCartera::orderBy('nombre')->get();
            $Acciones = DB::table('tbl_acciones')
                        ->join('tbl_estados', 'tbl_estados.id_estado', '=', 'tbl_acciones.id_estado_final')
                        ->select('tbl_acciones.id_accion', 'tbl_acciones.nombre', 'tbl_acciones.control', 'tbl_acciones.id_estado_final', 'tbl_estados.nombre as estado_final')->orderBy('tbl_acciones.nombre')->get();
            $Resultados = DB::table('tbl_resultados')
                        ->join('tbl_estados', 'tbl_estados.id_estado', '=', 'tbl_resultados.id_estado')
                        ->select('tbl_resultados.id_resultado', 'tbl_resultados.nombre', 'tbl_resultados.control', 'tbl_resultados.id_estado', 'tbl_estados.nombre as estado_final')->orderBy('tbl_resultados.nombre')->get();

            $EstadosCartera = EstadoCartera::orderBy('nombre')->get();
            return view('Admin.Parameters',
                ['Conceptos'=>$Conceptos,
                 'Acciones'=>$Acciones,
                 'EstadosCartera'=>$EstadosCartera,
                 'Resultados'=>$Resultados,
                'isUpdated'=>true ]);
        } else {
            return view('LogIn/LogIn', ['ErrorMsg'=>null]);
        }
    }

    function GetAccion($id_accion){
         if (session()->has('id_usuario')) {
            $CurrentAccion = Acciones::find($id_accion);
            return $CurrentAccion;}
        else {
            return view('LogIn/LogIn', ['ErrorMsg'=>null]);
        }
    }
    function SetStatusAcciones(Request $request){
        //Cambiar el estado al Registro
        $Ahora = now();
        $Hoy = $Ahora->format('Y-m-d');
        $IdAccion = $request->IdAccion;
        $IdEstado = $request->IdEstado;

        $CorrentAccion = Acciones::find($IdAccion);
        $CorrentAccion->control = $IdEstado;
        $Resp = $CorrentAccion->save();
        return $Resp;
    }

    function SaveResultados(UpdateResultadosRequest $request) {
        if (session()->has('id_usuario')) {
            if ($request->IdResultado){
                $Resultados = Resultados::find($request->IdResultado);
            } else {
                $Resultados = new Resultados();
            }
            $Resultados->nombre = strtoupper($request->NombreResultado);
            $Resultados->control = ($request->id_estado_resultado) ? 'A' : 'N';
            $Resultados->id_estado = $request->IdEstadoFinalResultado;
            $Resultados->save();
            $Conceptos = ConceptosCartera::orderBy('nombre')->get();
            $Acciones = DB::table('tbl_acciones')
                        ->join('tbl_estados', 'tbl_estados.id_estado', '=', 'tbl_acciones.id_estado_final')
                        ->select('tbl_acciones.id_accion', 'tbl_acciones.nombre', 'tbl_acciones.control', 'tbl_acciones.id_estado_final', 'tbl_estados.nombre as estado_final')->orderBy('tbl_acciones.nombre')->get();
            $Resultados = DB::table('tbl_resultados')
                        ->join('tbl_estados', 'tbl_estados.id_estado', '=', 'tbl_resultados.id_estado')
                        ->select('tbl_resultados.id_resultado', 'tbl_resultados.nombre', 'tbl_resultados.control', 'tbl_resultados.id_estado', 'tbl_estados.nombre as estado_final')->orderBy('tbl_resultados.nombre')->get();

            $EstadosCartera = EstadoCartera::orderBy('nombre')->get();
            return view('Admin.Parameters',
                ['Conceptos'=>$Conceptos,
                 'Acciones'=>$Acciones,
                 'EstadosCartera'=>$EstadosCartera,
                 'Resultados'=>$Resultados,
                'isUpdated'=>true ]);
        } else {
            return view('LogIn/LogIn', ['ErrorMsg'=>null]);
        }
    }

    function GetResultado($id_resultado){
         if (session()->has('id_usuario')) {
            $CurrentResultado = Resultados::find($id_resultado);
            return $CurrentResultado;}
        else {
            return view('LogIn/LogIn', ['ErrorMsg'=>null]);
        }
    }

    function SetStatusResultado(Request $request){
        //Cambiar el estado al Registro
        $Ahora = now();
        $Hoy = $Ahora->format('Y-m-d');
        $IdResultado = $request->IdResultado;
        $IdEstado = $request->IdEstado;

        $CorrentResultado = Resultados::find($IdResultado);
        $CorrentResultado->control = $IdEstado;
        $Resp = $CorrentResultado->save();
        return $Resp;
    }
}
