<?php

namespace App\Http\Controllers;
//Requests
use App\Http\Requests\LogInRequest;
use App\Http\Requests\UpdateImageProfile;
use App\Http\Requests\UpdatePasswdRequest;
use App\Http\Requests\UpdateProfile;
use App\Http\Requests\UpdateProfileRequest;
use App\Http\Requests\UpdateRolesRequest;
use App\Http\Requests\UpodateUsersRequest;
use Illuminate\Http\Request;
use App\Models\SysConsecutivos;
use Illuminate\Support\Facades\Crypt;

//Facades
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\DB;
use Illuminate\Container\Attributes\CurrentUser;
use Illuminate\Support\Carbon;


//Modelos
use App\Models\SysUsers;
use App\Models\SysRoles;
use App\Models\SysOpciones;
use App\Models\SysRolesOpciones;
use App\Models\MasterCustomer;

class GestorAserprhoController extends Controller
{
    //
     function LogIn(LogInRequest $request)
    {
    //Buscar el usuario y la contraseña
        $UsrName = strtoupper($request->ValidateEmail);
        $UsrPwd = $request->ValidatePasswd;
        //Por ahora solo buscar el Usuario porque la clave la establecemos con el Metodo Crypt
        session([
            'id_usuario' => null,
            'propietario' => null,
            'rol' => null,
            'id_perfil' => null,
            'avatar' => null
        ]);

        $CurrentUser = DB::table('sis_usuarios')
                            ->join('sis_perfiles', 'sis_usuarios.id_perfil', '=', 'sis_perfiles.id_perfil')
                            ->where('sis_usuarios.cuenta', '=', $UsrName)
                            ->select('sis_usuarios.*', 'sis_perfiles.nombre as rol')->first();

        if ($CurrentUser == null) {
             return view('LogIn/LogIn', ['ErrorMsg'=>'La cuenta de usuario no existe']);
        }

        //Rellenar la Sesion
        session([
                'id_usuario' => $CurrentUser->id_usuario,
                'propietario' => $CurrentUser->propietario,
                'rol' => $CurrentUser->rol,
                'email' => $CurrentUser->cuenta,
                'avatar' => ($CurrentUser->avatar) ? "storage/avatares/" . $CurrentUser->avatar : 'storage/avatares/user.png'
        ]);
        //Validar la contraseña
        $PassDecrypt = Crypt::decryptString($CurrentUser->clave);
        if ($UsrPwd != $PassDecrypt){
            return view('LogIn/LogIn', ['ErrorMsg'=>'La contraseña no es correcta.']);
        } else {
            return $this->Desktop();
        }
    }

    public function Desktop(){
        if (session()->has('id_usuario')) {
            $IdUsuario = session('id_usuario');
            $CurrentUser = SysUsers::find($IdUsuario);
            return view('Desktop', ['CurrentUser'=>$CurrentUser, 'isUpdated'=>false]);}
        else {
            return view('LogIn/LogIn', ['ErrorMsg'=>null]);
        }

    }

    function EditProfile()
    {
        if (session()->has('id_usuario')) {
            $IdUsuario = session('id_usuario');
            $CurrentUser = SysUsers::find($IdUsuario);
            return view('Admin.EditProfile', ['CurrentUser'=>$CurrentUser, 'isUpdated'=>false]);}
        else {
            return view('LogIn/LogIn', ['ErrorMsg'=>null]);
        }

    }

    function UpdateProfile(UpdateProfileRequest $request) {
            $IdUsuario = session('id_usuario');
            $CurrentUser = SysUsers::find($IdUsuario);

            $CurrentUser->cuenta = strtolower($request->email);
            //Encriptar
            $CurrentUser->clave  = crypt::encryptString($request->password);
            $CurrentUser->correo_electronico  = strtolower($request->email2);
            $CurrentUser->propietario  = strtoupper($request->fullname);
            $CurrentUser->telefono  = $request->telfijo;
            $CurrentUser->domicilio  = strtoupper($request->domicilio);
            $CurrentUser->celular  = $request->celular;
            $CurrentUser->ciudad  = strtoupper($request->ciudad);
            $CurrentUser->save();

            //Actualizar la Sesion
            session([
                'id_usuario' => $CurrentUser->id_usuario,
                'propietario' => $CurrentUser->propietario,
                'clave' => $CurrentUser->clave,
                'rol' => $CurrentUser->rol,
                'email' => $CurrentUser->cuenta,
                'avatar' => ($CurrentUser->avatar) ? "storage/avatares/" . $CurrentUser->avatar : 'storage/avatares/user.png'
        ]);

        return view('Admin.EditProfile', ['CurrentUser'=>$CurrentUser, 'isUpdated'=>true]);
    }

    function UpdateImageProfile(UpdateImageProfile $request){
        $IdUsuario = session('id_usuario');
        $CurrentUser = SysUsers::find($IdUsuario);
        $extension = $request->image->extension();
        $RenamedFile = strtolower($IdUsuario).".".$extension;
        $path = $request->file('image')->storeAs('avatares', $RenamedFile, 'public');
        $CurrentUser->avatar = $RenamedFile;
        $CurrentUser->save();
        //Actualizar la Sesion
        session([
                'id_usuario' => $CurrentUser->id_usuario,
                'propietario' => $CurrentUser->propietario,
                'clave' => $CurrentUser->clave,
                'rol' => $CurrentUser->rol,
                'email' => $CurrentUser->cuenta,
                'avatar' => ($CurrentUser->avatar) ? "storage/avatares/" . $CurrentUser->avatar : 'storage/avatares/user.png'
        ]);
        return view('Admin.EditProfile', ['CurrentUser'=>$CurrentUser, 'isUpdated'=>true]);
    }

    function UpdatePasswd(UpdatePasswdRequest $request){
        $IdUsuario = session('id_usuario');
        $CurrentUser = SysUsers::find($IdUsuario);
        //Encriptar
        $CurrentUser->clave  = crypt::encryptString($request->password);
        $CurrentUser->save();
        return view('Admin.EditProfile', ['CurrentUser'=>$CurrentUser, 'isUpdated'=>true]);
    }

    function LogOut(Request $request){
        $request->session()->flush();
        return view('LogIn/LogIn', ['ErrorMsg'=>null]);
    }

    function Roles (){
         if (session()->has('id_usuario')) {
            $Roles = SysRoles::all();
            return view('Admin.Roles', ['Roles'=>$Roles, 'isUpdated'=>false]);}
        else {
            return view('LogIn/LogIn', ['ErrorMsg'=>null]);
        }
    }

    function EditRol($IdRol){
        if (session()->has('id_usuario')) {
            $Rol = SysRoles::find($IdRol);
            //Seleccionar la Configuracion de Accesos para el Rol
            $Opciones = DB::select(
            "select sis_opciones.*,permisos.id_perfil, if(permisos.nivel_acceso is null, 'N',permisos.nivel_acceso) as nivel_acceso
            from sis_opciones
            left join (
                select * from sis_perfiles_opciones where sis_perfiles_opciones.id_perfil = '$IdRol'
            ) permisos
            on (permisos.id_opcion = sis_opciones.id_opcion) ");
            return view('Admin.EditRol', ['Rol'=>$Rol, 'Opciones'=>$Opciones, 'isUpdated'=>null]);
        } else {
            return view('LogIn/LogIn', ['ErrorMsg'=>null]);
        }
    }

    function NewRol(){
        if (session()->has('id_usuario')) {
            return view('Admin.NewRol', ['isUpdated'=>null]);
        } else {
            return view('LogIn/LogIn', ['ErrorMsg'=>null]);
        }
    }

     function UpdateRoles(UpdateRolesRequest $request) {
            $IdUsuario = session('id_usuario');
            if ($request->IdRol){
                $Rol = SysRoles::find($request->IdRol);
            } else {
                //Generar un Consecutivo
                //2: Codigo de Campo ppara Roles de Usuario
                $Id_Perfil = $this->getConsecutivo(2);
                $Rol = new SysRoles();
                $Rol->id_perfil = $Id_Perfil;
            }
            $Rol->nombre = strtoupper($request->nombre);
            $Rol->proposito = strtoupper($request->proposito);
            $Rol->aplicacion = strtoupper($request->aplicacion);
            $Rol->save();
            $Opciones = SysOpciones::all();
            return view('Admin.EditRol', ['Rol'=>$Rol, 'Opciones'=>$Opciones,'isUpdated'=>true]);
            //return redirect()->route('System.EditRol', $Rol->id_perfil);

     }


    function SetLevel(Request $request)
    {

        $IdOpcion = $request->IdOpcion;
        $IdPerfil = $request->IdPerfil;
        $NivelAcceso = $request->NivelAcceso;

        //Primero Encontrar

        $Encontrados = SysRolesOpciones::where('id_opcion', '=', $IdOpcion)->where('id_perfil', '=', $IdPerfil)->count();

        if ($Encontrados > 0) {
            $Borrar = SysRolesOpciones::where('id_opcion', '=', $IdOpcion)->where('id_perfil', '=', $IdPerfil)->delete();
        }

        $RolOpciones = new SysRolesOpciones();
        $RolOpciones->id_opcion = $IdOpcion;
        $RolOpciones->id_perfil = $IdPerfil;
        $RolOpciones->nivel_Acceso = $NivelAcceso;
        $RolOpciones->save();

        return 'Ok';
    }

    function Usuarios(){
         if (session()->has('id_usuario')) {
            $Roles = SysRoles::all();
            $SisUsuarios = DB::table('sis_usuarios')
            ->join('sis_perfiles', 'sis_usuarios.id_perfil', '=', 'sis_perfiles.id_perfil')
            ->select(DB::raw("sis_usuarios.*, sis_perfiles.nombre as rol,DATE_FORMAT(sis_usuarios.fecha_creacion,'%d/%m/%Y') AS creacion, DATE_FORMAT(sis_usuarios.fecha_ultimo_cambio,'%d/%m/%Y') AS fuc "))
            ->orderBy('sis_usuarios.id_estado')
            ->where('sis_usuarios.restringido', '=', 'N')
            ->get();

            return view('Admin.Usuarios', ['Roles'=>$Roles, 'Usuarios'=>$SisUsuarios, 'isUpdated'=>false ]);}
        else {
            return view('LogIn/LogIn', ['ErrorMsg'=>null]);
        }
    }

    function NewUser(){
        if (session()->has('id_usuario')) {
            return view('Admin.NewUser', ['isUpdated'=>null]);
        } else {
            return view('LogIn/LogIn', ['ErrorMsg'=>null]);
        }
    }

    function EditUser($IdUser){
        if (session()->has('id_usuario')) {
            $CurrentUser = SysUsers::find($IdUser);
            $Roles = SysRoles::all();
            $MasterCustomer = DB::select("
            select
                tbl_agrupaciones.id_agrupacion,
                tbl_agrupaciones.nombre,
                tbl_agrupaciones.id_estado,
                if(sis_usuarios_agrupacion.id_usuario is null, 'NO', 'SI') as Permitido, contar_unidades.unidades
            from tbl_agrupaciones
            left join
                (select *  from sis_usuarios_agrupacion where id_usuario = '$IdUser') sis_usuarios_agrupacion
            on sis_usuarios_agrupacion.id_agrupacion = tbl_agrupaciones.id_agrupacion
            left join
                ( select id_agrupacion, count(id_agrupacion) as unidades from tbl_cartera group by id_agrupacion) as contar_unidades
            on contar_unidades.id_agrupacion = tbl_agrupaciones.id_agrupacion
            where tbl_agrupaciones.id_estado = 1 and contar_unidades.unidades > 0 order by if(sis_usuarios_agrupacion.id_usuario is null, 'NO', 'SI') desc , tbl_agrupaciones.nombre
        ");


            return view('Admin.EditUser', ['CurrentUser'=>$CurrentUser, 'MasterCustomer'=>$MasterCustomer, 'Roles'=>$Roles,  'isUpdated'=>false]);}
        else {
            return view('LogIn/LogIn', ['ErrorMsg'=>null]);
        }
    }

    //Actualizar Registro de Usuario
    function UpdateUser(UpodateUsersRequest $request) {

            $Ahora = now();
            $Hoy = $Ahora->format('Y-m-d');

            $IdUsuario = $request->id_usuario;
            $CurrentUser = SysUsers::find($IdUsuario);

            $CurrentUser->cuenta = strtolower($request->email);
            $CurrentUser->correo_electronico  = strtolower($request->email2);
            $CurrentUser->propietario  = strtoupper($request->fullname);
            $CurrentUser->telefono  = $request->telfijo;
            $CurrentUser->domicilio  = strtoupper($request->domicilio);
            $CurrentUser->celular  = $request->celular;
            $CurrentUser->ciudad  = strtoupper($request->ciudad);
            $CurrentUser->id_perfil  = strtoupper($request->id_perfil);
            $CurrentUser->fecha_ultimo_cambio  = $Hoy;
            $CurrentUser->save();

            $Roles = SysRoles::all();
            $MasterCustomer = MasterCustomer::where('id_estado', '=', 1)->select('id_agrupacion', 'nombre')->get();

            return view('Admin.EditUser', ['CurrentUser'=>$CurrentUser, 'MasterCustomer'=>$MasterCustomer, 'Roles'=>$Roles,  'isUpdated'=>true]);
    }

    //Cambiar estado al Usuario
    function SetStatusUser(Request $request)
    {
        $Ahora = now();
        $Hoy = $Ahora->format('Y-m-d');
        $IdUsuario = $request->IdUsuario;
        $IdEstado = $request->IdEstado;

        $CurrentUser = SysUsers::find($IdUsuario);
        $CurrentUser->id_estado = $IdEstado;
        $CurrentUser->fecha_ultimo_cambio  = $Hoy;

        $Resp = $CurrentUser->save();
    }

    /*Cambiar Rol de Usuario*/
    function SetRole(Request $request)
    {
        $IdUsuario = $request->IdUsuario;
        $IdRol = $request->IdRol;
        $SisUsuarios = SysUsers::find($IdUsuario);
        $SisUsuarios->id_perfil = $IdRol;
        $SisUsuarios->fecha_ultimo_cambio = date('Y-m-d');
        $SisUsuarios->save();

        return 'OK';
    }

    //Cambiar estado al Rol
    function SetStatusRolTable(Request $request)
    {
        $Ahora = now();
        $Hoy = $Ahora->format('Y-m-d');
        $IdPerfil = $request->IdPerfil;
        $IdEstado = $request->IdEstado;

        $Rol = SysRoles::find($IdPerfil);
        $Rol->id_estado = $IdEstado;
        $Resp = $Rol->save();
    }

    /* Generacion de Consecutivos Personalizados */
    public function getConsecutivo($ID)
    {
       /* Identificadores para Campos consecutivos
       2: ID_PERFIL Para Roles de usuarios
       3: ID_USUARIO Para Codigos de Usuarios
       4: ID_CARTERA Para Identificador de Cartera
       6: ID_ACUERDO Para Identificadores de Acuerdos de Pago
       9: ID_CCOBRO Para Cuentas de Cobro
       22: ID_COMPROBANTE Para Comprobantes de Recaudo
       23: ID_RECIBOCAJA Para Recibos de Caja
       */
        $SysConsecutivos = SysConsecutivos::find($ID);
        $NuevoConsecutivo = $SysConsecutivos->consecutivo;
        $LongCadena = $SysConsecutivos->long_cadena;
        $NuevoConsecutivo++;
        $SysConsecutivos->consecutivo = $NuevoConsecutivo;
        $SysConsecutivos->save();

        $FillChar = $SysConsecutivos->caracter_relleno;
        $Prefijo = $SysConsecutivos->prefijo;
        $LenPrefijo = strlen($Prefijo);

        //contar cuantos digitos tiene el Consecutivo
        $largo = strlen($NuevoConsecutivo);
        $new_id = $Prefijo . str_repeat("0", ($LongCadena - $largo) - $LenPrefijo) . $NuevoConsecutivo;
        return $new_id;
    }
}

