<?php

namespace App\Http\Controllers;

use App\Http\Requests\UpdateAgrupacionRequest;
use Illuminate\Http\Request;

//Favcades
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Carbon;

//Models
use App\Models\MasterCustomer;
use App\Models\Segmentos;
use App\Models\SysUsers;
use App\Models\Bancos;
use App\Models\Contactos;

class AserprhoCartera extends Controller
{
    function Copropiedades(){
         if (session()->has('id_usuario')) {
            $IdUsuario = session('id_usuario');
            return view('Customers.Customers', ['isUpdated'=>false]);}
        else {
            return view('LogIn/LogIn', ['ErrorMsg'=>null]);
        }
    }

    function ListarCopropiedades($scope){
         if (session()->has('id_usuario')) {
            if($scope == -1) {
                $Agrupaciones = MasterCustomer::orderBy('nombre')->get();
            } else {
                $Agrupaciones = MasterCustomer::where('id_estado', '=', $scope)->orderBy('nombre')->get();
            }
            return $Agrupaciones;}
        else {
            return view('LogIn/LogIn', ['ErrorMsg'=>null]);
        }
    }

    function EditCustomer($IdAgrupacion, $isUpdated){
         if (session()->has('id_usuario')) {
            $IdUsuario = session('id_usuario');
            $Agrupacion = MasterCustomer::find($IdAgrupacion);
            //Usuario Creador
            $UsrCreador = SysUsers::find($Agrupacion->created_by);
            //Usuario Actualiza
            $UsrActualiza = SysUsers::find($Agrupacion->updated_by);
            //Lista de Usuarios
            $Usuarios = DB::table('sis_usuarios')->where('sis_usuarios.id_estado', '=', 'CA')->orderBy('sis_usuarios.propietario')->get();
            //Lista de contactos
            $Contactos = DB::table('tbl_agrupacion_contacto')->where('tbl_agrupacion_contacto.id_agrupacion', '=', $IdAgrupacion)->get();
            //Autorizacoines
            $UsrAutorizados = DB::table('sis_usuarios')
            ->join('sis_usuarios_agrupacion', 'sis_usuarios_agrupacion.id_usuario', '=', 'sis_usuarios.id_usuario')
            ->select(DB::raw('CONCAT(UCASE(MID(sis_usuarios.propietario,1,1)),LCASE(MID(sis_usuarios.propietario,2))) as propietario'), 'sis_usuarios.avatar')
            ->where('sis_usuarios_agrupacion.id_agrupacion', '=', $IdAgrupacion)
            ->where('sis_usuarios.id_estado', '=', 'CA')->get();
            //Segmentos
            $Segmentos = Segmentos::all();
            //Bancos
            $Bancos = Bancos::all();
            /* Calculemos el Total*/
            $TotalDeuda = DB::table('tbl_cartera')
                            ->where('tbl_cartera.id_agrupacion', '=', $IdAgrupacion)
                            ->selectRaw('SUM(tbl_cartera.capital_deuda) as total_deuda')
                            ->selectRaw( 'COUNT(tbl_cartera.unidad) as cantidad')
                            ->groupBy('tbl_cartera.id_agrupacion')
                            ->first();

            return view('Customers.EditCustomer', ['Agrupacion'=>$Agrupacion,
                                                    'total_deuda'=>0,
                                                    'Usuarios'=>$Usuarios,
                                                    'UsrAutorizados'=>$UsrAutorizados,
                                                    'Bancos'=>$Bancos,'UsrCreador'=>$UsrCreador,'UsrActualiza'=>$UsrActualiza,
                                                    'TotalDeuda'=>$TotalDeuda,
                                                    'Segmentos'=>$Segmentos,
                                                    'Contactos'=>$Contactos,
                                                    'isUpdated'=>$isUpdated]);}
        else {
            return view('LogIn/LogIn', ['ErrorMsg'=>null]);
        }
    }

    function ListarCartera1($id_agrupacion){
         if (session()->has('id_usuario')) {

                $Cartera = DB::table('tbl_cartera')
                ->join('tbl_estados', 'tbl_estados.id_estado', '=', 'tbl_cartera.id_estado')
                ->join('tbl_tipo_unidad', 'tbl_tipo_unidad.id_tipo_unidad', '=', 'tbl_cartera.id_tipo_unidad')
                ->where('tbl_cartera.id_agrupacion', '=', $id_agrupacion)
                ->select('tbl_cartera.unidad', 'tbl_tipo_unidad.nombre as tipo','tbl_cartera.capital_deuda','tbl_cartera.meses_deuda',
                        DB::raw('CONCAT(UCASE(MID(tbl_estados.nombre,1,1)),LCASE(MID(tbl_estados.nombre,2))) as estado' ),'tbl_estados.bloquear')->get();
            return $Cartera; }
        else {
            return view('LogIn/LogIn', ['ErrorMsg'=>null]);
        }
    }

    function UpdateContact(Request $request) {
        if (session()->has('id_usuario')) {

            $IdAgrupacion = $request->IdAgrupacion;
            $IdContact = $request->IdContact;
            $NombreContacto = $request->NombreContacto;
            $Telefono = $request->TelContacto;
            $Email = $request->EmailContacto;
            $Posicion = $request->PosicionContacto;
            $Ahora = now();
            $Hoy = $Ahora->format('Y-m-d');
            if ($IdContact){
                $CurrentContact = Contactos::find($IdContact);
            } else {
                $CurrentContact = new Contactos();
            }
            $CurrentContact->id_agrupacion = $IdAgrupacion;
            $CurrentContact->nombre_contacto = $NombreContacto;
            $CurrentContact->telefono = $Telefono;
            $CurrentContact->email = $Email;
            $CurrentContact->posicion = $Posicion;
            $CurrentContact->save();
            return redirect('/EditCustomer/'.$IdAgrupacion."/1");
           //return $this->EditCustomer($IdAgrupacion, true);
        }
            else {
                return view('LogIn/LogIn', ['ErrorMsg'=>null]);
            }
    }

    function UpdateAgrupacion(UpdateAgrupacionRequest $request){

        if (session()->has('id_usuario')) {
            $IdUsuario = session('id_usuario');
            $IdCopropiedad = $request->IdAgrupacion;
            $Ahora = now();
            $Hoy = $Ahora->format('Y-m-d');

            $Nit = $request->Nit;
            $NombreCopropiedad = strtoupper($request->Nombre);
            $NombreComercial = strtoupper($request->NombreComercial);
            $Direccion = strtoupper($request->Domicilio);
            $Correo = strtolower($request->Email);
            $Telefono1 = $request->Telefono;
            $Celular = $request->Celular;
            $Administrador = strtoupper($request->NombreAdministrador);
            $Honorarios = $request->PercHonPre;
            $Intereses = $request->PercInteres;
            $HonJuridico = $request->PercHonJuridico;
            $IdOwner = $request->id_owner;
            $IdBanco = $request->id_banco;
            $NumeroCuenta = $request->Numcuenta;
            $TipoCuenta = $request->TipoCuenta;
            $IdSegmento = $request->id_segmento;
            $CobrarIva = ($request->cobrar_iva == 'on' ? '1' : '0');
            $IdEstadoCopropiedad = ($request->id_estado == 'on' ? '1' : '0');
               //$Observaciones = $request->Observaciones;


            //AddRecord
            if ($IdCopropiedad == "") {
               $Agrupaciones = new MasterCustomer();
                //Ahora Asegurar que el usuario que hace la Actualización tenga acceso a la Copropiedad
                $Pre = DB::table('sis_usuarios_agrupacion')->where('id_usuario', '=', $IdUsuario)
                ->where('id_agrupacion', '=', $IdCopropiedad)
                ->delete();
                //Ahora inserar
                DB::table('sis_usuarios_agrupacion')->insert(
                    ['id_usuario' => $IdUsuario, 'id_agrupacion' => $IdCopropiedad]
            );

            }
            else {
                $Agrupaciones = MasterCustomer::find($IdCopropiedad);
            }

            $Agrupaciones->nit = $Nit;
            $Agrupaciones->nombre = $NombreCopropiedad;
            $Agrupaciones->nombre_comercial = $NombreComercial;
            $Agrupaciones->domicilio = $Direccion;
            $Agrupaciones->telefono1 = $Telefono1;
           // $Agrupaciones->telefono2 = $Telefono2;
            $Agrupaciones->celular = $Celular;
            $Agrupaciones->correo = $Correo;
            $Agrupaciones->tasa_interes = $Honorarios;
            $Agrupaciones->hon_juridico = $HonJuridico;
            $Agrupaciones->cobrar_iva = $CobrarIva;
            $Agrupaciones->administrador = $Administrador;
            $Agrupaciones->numero_cuenta = $NumeroCuenta;
            $Agrupaciones->id_banco = $IdBanco;
            $Agrupaciones->tipo_cuenta = $TipoCuenta;
            $Agrupaciones->tasa_mora = $Intereses;
            $Agrupaciones->id_estado = $IdEstadoCopropiedad;
            $Agrupaciones->id_owner = $IdOwner;
            $Agrupaciones->updated_by = $IdUsuario;
            $Agrupaciones->date_updated = $Ahora;
            $Agrupaciones->id_segmento = $IdSegmento;
            //$Agrupaciones->observaciones = $Observaciones;
            if($Agrupaciones->save()){
                return redirect('/EditCustomer/'.$IdCopropiedad."/1");
            }
        } else {
            return view('LogIn/LogIn', ['ErrorMsg'=>null]);
        }
    }
}
