<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class UsersExport implements FromCollection,WithHeadings, ShouldAutoSize
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        $SisUsuarios = DB::table('sis_usuarios')
            ->join('sis_perfiles', 'sis_usuarios.id_perfil', '=', 'sis_perfiles.id_perfil')
            ->select(DB::raw("sis_usuarios.cuenta,sis_usuarios.propietario, sis_usuarios.telefono, sis_usuarios.id_estado, sis_perfiles.nombre as rol,DATE_FORMAT(sis_usuarios.fecha_creacion,'%d/%m/%Y') AS creacion, DATE_FORMAT(sis_usuarios.fecha_ultimo_cambio,'%d/%m/%Y') AS fuc "))
            ->orderBy('sis_usuarios.id_estado')
            ->where('sis_usuarios.restringido', '=', 'N')
            ->get();
            return $SisUsuarios;
    }

    public function headings(): array
    {
        return [
            'CUENTA',
            'PROPIETARIO',
            'TELEFONO',
            'ESTADO',
            'ROL DE USUARIO',
            'F.CREACIÓN',
            'F.ACTUALIZACIÓN'
        ];
    }
}
