<?php

namespace App\Exports;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\FromCollection;

class ResultadosExport implements FromCollection, WithHeadings, ShouldAutoSize
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
         $Resultados = DB::table('tbl_resultados')
                        ->join('tbl_estados', 'tbl_estados.id_estado', '=', 'tbl_resultados.id_estado')
                        ->select('tbl_resultados.id_resultado', 'tbl_resultados.nombre', 'tbl_resultados.control', 'tbl_estados.nombre as estado_final')->orderBy('tbl_resultados.nombre')->get();
        return $Resultados;
    }

     public function headings(): array
    {
        return [
            'ID',
            'NOMBRE RESULTADO',
            'ACTIVO',
            'ESTADO FINAL'
        ];
    }
}
