<?php

namespace App\Exports;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class AccionesExport implements FromCollection, WithHeadings, ShouldAutoSize
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        $Acciones = DB::table('tbl_acciones')
                        ->join('tbl_estados', 'tbl_estados.id_estado', '=', 'tbl_acciones.id_estado_final')
                        ->select('tbl_acciones.id_accion', 'tbl_acciones.nombre', 'tbl_acciones.control', 'tbl_estados.nombre as estado_final')->orderBy('tbl_acciones.nombre')->get();
        return $Acciones;
    }

    public function headings(): array
    {
        return [
            'ID',
            'NOMBRE ACCION',
            'ACTIVO',
            'ESTADO FINAL'
        ];
    }
}
